#!/bin/sh
# ftp://ftp.cs.bham.ac.uk/pub/dist/poplog/setup/bin/poplog.sh
# http://www.cs.bham.ac.uk/research/poplog/setup/bin/poplog.sh
# $poplocal/local/setup/bin/poplog.sh

## Version for sh, bash and ksh users (sourced or run as a script)

# Aaron Sloman
# 24 Aug 2001
# Changed 23 Apr 2002, to uses current.poplog link instead of v15.53

# See also the poplogmail.sh script in this directory

# NB NB Please edit the "." lines to suit your installation
# The default poplogroot may not be best for you.

# Purpose:
# Script which sets up poplog environment variables, and then runs
# The command given as argument (e.g. pop11, xved, clisp, etc.)
# When used like this it sets the environment variables only in the
# process that runs the script.

# Can be "sourced" instead, to set environment variables for a whole
# login session, or in an xterm, e.g. in the user's startup file


## In the first mode, its csh equivalent can be invoked by users of any
## shell, with commands such as
##
##    poplog pop11
##    poplog ved
##    poplog xved <file>
##    poplog prolog
##    poplog clisp
##    poplog pml
##    poplog pop11 +eliza

## In the second mode, invoke this as something like this:
##    . /usr/local/poplog/local/setup/bin/poplog.sh

# setup local directory tree for poplog root
# may be a symbolic link to something else

## THIS IS A DEFAULT WHICH MAY NEED TO BE EDITED AT YOUR SITE
poplogroot=/usr/local/poplog
export poplogroot

## THIS MAY ALSO NEED TO BE EDITED
usepop=$poplogroot/current.poplog
##usepop=$poplogroot/solaris.current
export usepop

# Set the poplocal variables

## THIS MAY ALSO NEED TO BE EDITED
poplocal=$poplogroot
local=$poplocal/local
export poplocal local

# Run the initialisation files to set up additional environment
# variables, extend $PATH, etc.
# THIS IS THE "STANDARD" poplog "login" file. It sources several others
. $usepop/pop/com/poplog.sh

# (Optional)
# Set $EDITOR and $VISUAL, unless set by users. Users can undo this.


## THESE MAY ALSO NEED TO BE EDITED
## Make ved the default visual editor
EDITOR=${EDITOR=ved}
    export EDITOR

VISUAL=${VISUAL=ved}
    export VISUAL

if [ "$DISPLAY" != "" ]
then
    # DISPLAY set. Using X, so set resources

    # Extend X resources for Ved in xterm, Xved etc.
    # Read user's file if it exists, otherwise system version
    if [ -f $HOME/.Xdefaults.poplog ] ;
    then

        # Get user's version
        xrdb -merge $HOME/.Xdefaults.poplog

    else
        # Defaults may not be ideal.
        # E.g. check font size for XVed
        xrdb -merge $poplocal/local/setup/Poplib/Xdefaults.poplog
    fi

fi


## Check if user has a location for init.p, vedinit.p etc. and if not
## use a default location (MUST EXIST)

if [ -f $HOME/Poplib ]
then
    poplib=$HOME/Poplib
elif [ -f $HOME/poplib ] ;
then
    poplib=$HOME/poplib
else
    ## A place where local versions of init.p, vedinit.p init.lsp etc.
    ## can be located
    ## Current versions supplied in setup.tar.gz are a mess and need to
    ## be reorganised. (A.Sloman 24 Aug 2001)

    poplib=$poplocal/local/setup/Poplib
fi
export poplib

# If sourced (with no arguments) do nothing, but leave environment
# variables set.
# If run with arguments, run the command given. Use exec to save a proces.

if [ "$*" != "" ]
then
    exec $*
fi
