/* --- Copyright University of Birmingham 2004. All rights reserved. ------
 > File:            $poplocal/local/auto/ved_cleanmail.p
 > Purpose:			Tidy certain sorts of encoded email messages
 > Author:          Aaron Sloman, Dec 15 1999 (see revisions)
 > Documentation:
 > Related Files:
 */

/*
HELP ved_cleanmail

ENTER cleanmail
(inside an email message.)

ENTER cleanmail all
(whole file)

ENTER cleanmail mr
(marked range)

A first attempt to get rid of funny "=" joining broken
lines and other symbols starting with "=". Must find the relevant
documentation some day and do this properly.


*/

define ved_cleanmail();
	dlocal ved_search_state, vedbreak = false, vvedworddump, vvedlinedump ;
	vedpositionpush();
	if vedargument = 'all' then
		;;; mark whole file
		ved_mbe()
	elseif vedargument = 'mr' then
		;;; use current marked range
	else
		;;; mark mail message
		ved_mcm();
	endif;
	;;; do the replacements
	;;; CR/LF
	veddo('gsr/=0D=0A/\\n/');
	;;; LF at beginning of line, ignore
	veddo('gsr/@a=0A//');
	veddo('gsr/=09/-/');
	;;; LF
	veddo('gsr/=0A/\\n/');
	;;; CR
	veddo('gsr/=0D/\\n');
	veddo('gsr/=20/ /');
	veddo('gsr/=2C/,/');
	veddo('gsr/=2E/./');
	veddo('gsr.=2F./.');
	veddo('gsr/=3A/:/');
	veddo('gsr/=3F/?/');
	veddo('gsr/=46/F/');
	veddo('gsr/=46/F/');
	veddo('gsr/=5F/_/');
	veddo('gsr/=91/`/');
	veddo('gsr/=92/\'/');
	veddo('gsr/=93/`/');
	veddo('gsr/=94/\'/');
	veddo('gsr/=96/--/');
	veddo('gsr/=97/--/');
	;;; veddo('gsr" =@z@a" "');
	veddo('gsr/=A0//');
	veddo('gsr/=A3//');
	veddo('gsr/=AB/`/');
	veddo('gsr/=AD/--/');
	veddo('gsr/=B4/\'/');
	veddo('gsr/=B7/o/');
	veddo('gsr/=B9/\'/');
	veddo('gsr/=BB/\'/');
	veddo('gsr/=D5/\'/');
	veddo('gsr/=DF/ss/');
	veddo('gsr/=D2/`/');
	veddo('gsr/=D3/\'/');
	veddo('gsr/=E7//');	;;; ???
	veddo('gsr/=E9//');	;;; ???
	veddo('gsr/=EB//');	;;; ???
	veddo('gsr/=FC//');   ;;; ue
	veddo('gsr/=F3//');
	veddo('gsr/=A1=AF/\'/');
	veddo('gsr/=A7//'); 	;;; not $
	;;; or this (bullet?)
	veddo('gsr/=85/o/');
	veddo('gsr/=40/@@/');
	veddo('gsr/=3D/=/');
	;;; redo in case:
	;;;veddo('gsr/ =@z@a/ /');
	;;; join up lines ending with "="
	vedjumpto(vvedmarkhi, 1);
	repeat
		vedcharup(); vedtextright();
		if vedcolumn > 50 then
			vedcharleft();vedcharleft();
			lvars last_char = vedcurrentchar();
			if last_char /== `=` then
				vedcharright();
				if vedcurrentchar() == `=` then
					;;; it is a line ending with `=`
					;;; so join next line to it
					veddotdelete();		;;; delete `=`
					;;; go to next line
					vednextline();
					;;; save the text and delete it
					lvars text = vedthisline();
					vedlinedelete();
					;;; add at end of previous line
					vedcharup();
					vedtextright();
					if last_char == `\s` then vedcharright() endif;
					vedinsertstring(text);
				endif;
			endif;
		endif;
		quitif(vedline == vvedmarklo);
	endrepeat;
	vedpositionpop();
enddefine;

/* --- Revision History ---------------------------------------------------
--- Aaron Sloman, Oct  5 2002
		Added more line breaks.
--- Aaron Sloman, Aug 22 2002
		added 5F for _
			  3F for ?
--- Aaron Sloman, Feb  1 2001
	Fixed cases where end of line is  space then "=".
--- Aaron Sloman, May 20 2000
	added =D2 =D3
	Made it deal better with =@z@a

--- Aaron Sloman, Apr 11 2000
	Added "mr" option
	Added more cases =FC =DF
--- Aaron Sloman, Mar 15 2000
	added "all" option etc.
--- Aaron Sloman, Jan  9 2000
	dlocalised ved_search_state
 */
