/* --- Copyright University of Sussex 1993.  All rights reserved. ---------
 > File:           C.vms/lib/ved/ved_dclfile.p
 > Purpose:        run dcl in a ved file
 > Author:         Roger Evans, Aug 1983 (see revisions)
 > Documentation:  HELP * DCL_COMPILE
 > Related Files:
 */
compile_mode :pop11 +strict;

section;

uses dcl_subsystem;
uses ved_killdcl;

define veddcldefaults();
	vedveddefaults();
	false -> vedwriteable;
	false -> vedbreak;
	8 -> vedindentstep;
enddefine;

vars procedure ved_dclfile;
if isundef(ved_dclfile) then
	popexit <> procedure; ved_killdcl() endprocedure -> popexit;
endif;

define vars ved_dclfile();
	vedsetup();
	if vedargument = nullstring then 'dclfile' -> vedargument endif;
	vededit([^vedargument ^false dcl_subsystem], veddcldefaults);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- John Gibson, Jan 13 1993
		Uses dcl_subsystem
--- Ben Rubinstein, Dec 16 1986 - stopped previous popexit being overwritten
*/
