/*  --- Copyright University of Sussex 1989.  All rights reserved. ---------
 >  File:           C.vms/lib/ved/ved_send.p
 >  Purpose:        For sending mail inside VED <enter> send/sendmr
 >  Author:         various (see revisions)
 >  Documentation:  HELP * SEND
 >  Related Files:  LIB * VED_SENDMR
 */
compile_mode :pop11 +strict;

section $-ved => ved_send ved_sendmr;

vars
	ved_send_target_prefixes = ['TO' 'To' 'to'],
	ved_send_subject_prefixes =
		['RE' 'Re' 're' 'Subject' 'subject' 'Subj' 'SUBJ' 'SUBJECT' 'subj'],
	;

define lconstant mailcommand(mailfile, address, subject) -> commandfile;
	lvars	mailfile, address, subject, commandfile;
	dlocal	cucharout, pr = syspr, pop_pr_quotes = false;
	systmpfile(false, 'mail', '.com') -> commandfile;
	discout(commandfile) -> cucharout;
	printf('$ mail\n');
	printf('send/noedit/nocc_prompt/subj="%p" %p\n', [^subject ^mailfile]);
	printf('%p\n', [^address]);
	printf('$\n');
	cucharout(termin);
enddefine;

define vedsend(whole_file);
	lvars	whole_file, subject, names, loc, prefix, line, commandfile;
	dlocal	vedchanged, vedargument, cucharout, vedautowrite,
			vedpositionstack, vvedmarkprops, ved_search_state;
	charout -> cucharout;   ;;; sysobey prints a newline. Don't let it cause
	;;; vedrestorescreen to be printed
	vedmarkpush();
	false ->> vedautowrite -> vvedmarkprops;

	if vedargument = nullstring then false else space >< vedargument
	endif -> names;

	nullstring -> subject;
	if whole_file then
		1 -> vvedmarklo; vvedbuffersize -> vvedmarkhi;
		'WHOLE FILE'
	else
		if vvedmarklo > vvedmarkhi then
			vedmarkpop();vederror('NO MARKED RANGE TO SEND')
		endif;
		'MARKED RANGE'
	endif -> whole_file;

	vedpositionpush();
	vedmarkfind();

	/* Find the first non-empty line in marked range */
	ved_try_search('@?', []) -> ;

	vedthisline() -> line;
	locchar(`:`,1,line) -> loc;
	if names then
	elseif loc then
		substring(1,loc fi_- 1, line) -> prefix;
		if member(prefix, ved_send_target_prefixes)
		and (substring(loc fi_+ 1, vvedlinesize fi_- loc, line) ->> names)
			/= nullstring
		then
			vednextline();
			vedline -> vvedmarklo;
			ved_try_search('@?', []) -> ;	;;; find non-empty line
			vedthisline() -> line;
			locchar(`:`,1,line) -> loc;
		endif;
	endif;

	if not(names) or names = nullstring then
		vedmarkpop();vederror('SEND MAIL TO WHO?')
	endif;

	if loc then
		substring(1,loc fi_- 1, line) -> prefix;
		if member(prefix,ved_send_subject_prefixes) then
			skipchar(` `, loc fi_+ 1, line) -> loc;
			if loc then
				substring(loc, vvedlinesize fi_- loc fi_+ 1,line) -> subject;
				vednextline();
				vedline -> vvedmarklo;
			else vedmarkpop();vederror('WHAT SUBJECT?')
			endif;
		endif;
	endif;
	;;; write to temporary file
	systranslate('SYS$LOGIN') >< 'vedmessage.lis' -> vedargument;
	sysfileok(vedargument) -> vedargument;
	vedpositionpop();
	ved_wr();
	vedmarkpop();
	vedputmessage('SENDING MAIL -- ' >< whole_file);
	mailcommand(vedargument, names, subject) -> commandfile;
	sys_spawn('@' sys_>< commandfile, false, sysfileok('/dev/null'), true, false) -> ;
	sysdelete(commandfile) -> ;
	100 -> vedscreenline;   ;;; cursor may have moved.
	vedputmessage('MAIL SENT: VEDMESSAG.LIS FILE DELETED');
	vedscreenbell();
	erase(sysdelete(vedargument));
	vedscr_flush_output();
	false -> vedprintingdone;
enddefine;

define vars ved_send;     vedsend(true) enddefine;
define vars ved_sendmr;   vedsend(false) enddefine;

endsection;

/*  --- Revision History ---------------------------------------------------
--- Rob Duncan, Nov  9 1989
	Changed to spawn a mail command file rather than using -sysobeylist-,
	which couldn't cope with `!` in the address. See ISL FR 4288.
--- Rob Duncan, Apr  5 1989
	Removed Unix-specific code, since this is now a VMS-only file.
	Replaced -vednullstring- with -nullstring-
--- Robert Duncan, May 12 1987
	Changed to use -sysobeylist- in order to invoke mail with output
	redirected and prevent terminal interference. See SD SFR 4049.
--- Aaron Sloman, Oct 29 1986 restricted to VMS. UNIX versions will get more
		elaborate version. This will remain as LIB OLDSEND on UNIX
--- Mark Rubinstein, May 22 1985 - alterd to use SYS_OS_TYPE
--- Aaron Sloman, March 25 1985 - used vedmarkpush and vedmarkpop
--- Mark Rubinstein, March 21 1985 - bug fixed to send apostrophes in subject
	line without hanging up
--- Aaron Sloman, March 13 1985 - used vedte*stsearch to find non-empty line.
	added ability to specify names with TO: or To:
	Suppressed deleting and adding lines. Just shift vvedmarklo
	cleaned up garbage - unused variables, etc. etc.
--- Mark Rubinstein, Jan 29 1985 -fixed to run on both unix and vms
 */
