$! --- Copyright University of Sussex 1993. All rights reserved. ----------
$! File:            C.vms/src/mksyscomp.com
$! Purpose:			Build saved images for POPC, POPLINK and POPLIBR
$! Author:          John Gibson, Jun 27 1988 (see revisions)
$!
$! Usage: @mksyscomp [image ...]
$! 	(where 'image' is popc, poplink or poplibr)
$
$ on error then exit
$
$ dir := 'f$logical("POPAUTOLIB")'
$ if dir .eqs. ""
$ then
$ 	write sys$output "mksyscomp: doing [pop.com]popenv to assign logical names"
$ 	@usepop:[pop.com]popenv
$ endif

$ corepop11 := $popsys:corepop11
$
$
$ makeimage:
$	subroutine
$		! For Alpha, use a bigger pop_shrim_margin since we can't get rid of
$		! all shareable images
$ 		if f$getsyi("NODE_HWTYPE") .eqs. "ALPH" then -
					define/user pop_shrim_margin 50
$
$ 		corepop11 \%nort \%noinit ":constant IMAGE=uppertolower(""''p1'""); pop11_compile(charin);"
			false -> pop_debugging;
			procedure;
				dlocal current_directory = 'usepop:[pop.src.syscomp]';
				pop11_compile("make_" <> IMAGE);
			endprocedure();
			make_saved_image('popsys:' sys_>< IMAGE sys_>< '.psv');
			sysexit();
$ 		pu popsys:'p1'.psv
$	endsubroutine
$
$ if p1 .nes. "" then call makeimage 'p1'
$ if p2 .nes. "" then call makeimage 'p2'
$ if p3 .nes. "" then call makeimage 'p3'
$

$! --- Revision History ---------------------------------------------------
$! --- John Gibson, Dec  6 1994  Added setting of pop_shrim_margin for Alpha
$! --- John Gibson, Dec  2 1993
$!		Put compile code inside a procedure with dlocal'ed current_directory
$! --- Simon Nichols, Dec  1 1993
$!		Changed assignment to current_directory from 'popsrc:syscomp' to
$!		'usepop:[pop.src.syscomp]'.
$!		Added %nort and %noinit flags to invocation of corepop11.
$! --- John Gibson, Jul 11 1993  Image now built in popsys on corepop11
$! --- Robert John Duncan, Jan 10 1992
$!		Changed to allow up to 3 arguments and always to use safepop11
$! --- John Gibson, Jun  7 1989
$!		Added false -> pop_debugging
