/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:			S.axpvms/src/registers.ph
 > Purpose:			Logical names for Alpha registers (VMS)
 > Author:			John Gibson, Aug 18 1994
 */

lconstant macro (
	REG_PREFIX	= 'r',
	FREG_PREFIX	= 'f',

	RGt0		= 0,		;;; temp 0
	RGt1		= 1,		;;; temp 1

	RGpl0		= 2,		;;; pop locals 0 - 10  (VMS locals too)
	RGpl1		= 3,
	RGpl2		= 4,
	RGpl3		= 5,
	RGpl4		= 6,
	RGpl5		= 7,
	RGpl6		= 8,
	RGpl7		= 9,
	RGpl8		= 10,
	RGpl9		= 11,
	RGpl10		= 12,

	RGnpl2		= 13,		;;; nonpop locals 2 - 4 (VMS locals too)
	RGnpl3		= 14,
	RGnpl4		= 15,

	RGt3		= 16,		;;; temp 3 - 6
	RGt4		= 17,
	RGt5		= 18,
	RGt6		= 19,

	RGnpl0		= 20,		;;; nonpop locals 0 - 1 (not VMS locals)
	RGnpl1		= 21,

	RGfalse		= 22,		;;; <false>
	RGsvb		= 23,		;;; special var block pointer
	RGusp		= 24,		;;; user stack pointer
	RGchain		= 25,		;;; chain_reg / temp 7		(AI reg)
	RGret		= 26,		;;; return address / temp 8
	RGpb		= 27,		;;; procedure base
	RGt2		= 28,		;;; temp 2
	RGfp		= 29,		;;; system frame pointer
	RGsp		= 30,		;;; system stack pointer
	RGzero		= 31,		;;; zero / sink
);
