/* --- Copyright University of Sussex 1990. All rights reserved. ----------
 > File:            C.vms/src/sys_input_waiting.p
 > Purpose:			Test for input waiting on a device
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *SYSIO
 */


#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'vmsdefs.ph'

section $-Sys$-Io;

constant
		procedure (Mbx_test_input, Trm_test_input)
	;

endsection;

;;; ---------------------------------------------------------------------

section $-Sys$-Io => sys_input_waiting;

define Test_input(dev);
	lvars dev, ctrl_blk, buf = dev!D_IN_BUFFER, _count, _chan;
	if _zero(buf!BUF_COUNT _sub buf!BUF_POSITION ->> _count)
	and dev!D_FLAGS _bitst _M_D_INTERACTIVE then
		;;; terminal/mailbox
		dev!D_CTRL_BLK -> ctrl_blk;
		ctrl_blk!ICB_CHANNEL -> _chan;
		if ctrl_blk!ICB_DEVCHAR _bitst _:'DEV$M_MBX' then
			Mbx_test_input(_chan)
		else
			Trm_test_input(_chan)
		endif
	else
		_pint(_count)
	endif
enddefine;

define sys_input_waiting(dev);
	lvars dev;
	Check_device(dev, true);
	fast_apply(dev, dev!D_TEST_INPUT)
enddefine;

endsection;		/* $-Sys$-Io */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov 29 1990
		Various changes
--- John Gibson, Oct 24 1990
		Now calls D_TEST_INPUT procedure
--- John Gibson, Oct 11 1990
--- John Gibson, Jul 27 1989
		Revised -sys_input_waiting- to correct bug
--- John Gibson, Feb 19 1989
		Included io.ph
--- John Williams, Oct  6 1988
		Fixed for VED devices
--- John Gibson, Apr 13 1988
		Moved out of sysio.p
 */
