/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:			C.vms/src/sys_spawn.p
 > Purpose:			Spawn a new process
 > Author:			Robert John Duncan, Sep  5 1994
 > Documentation:	REF * SYSUTIL
 > Related Files:	C.all/src/os_process.p
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'
#_INCLUDE 'signals.ph'

weak global constant
		procedure sys_async_io
	;

section $-Sys;

constant
		procedure ( Add_os_process_entry, Vms_set_Ctrl_C ),
		_vmsproc_tab, _vmsproc_tab_lim
	;

endsection;

;;; -----------------------------------------------------------------------

section $-Sys => pop_spawn_flags, sys_spawn;

vars
	pop_spawn_flags	= 0,		;;; flags for lib$spawn
	;

define Waitpid(_pid, _status_id);
	lvars _entry = _vmsproc_tab, _pid, _status_id;
	;;; find process _____pid in process table
	while _entry <@(struct PROC_ENTRY) _vmsproc_tab_lim do
		if _entry!PROC_PID == _pid then
			if _neg(_entry!PROC_COND) then
				;;; process is dead -- free entry and return status
				_entry!PROC_STATUS -> _status_id!(w);
				_0 -> _entry!PROC_COND;					;;; free entry
				return(termin)
			else
				return(true)
			endif;
		endif;
		_entry@(struct PROC_ENTRY)++ -> _entry
	endwhile;
	true
enddefine;

define sys_spawn(command, input, output, wait, will_do_wait);
	lvars	command, input, output, wait, will_do_wait, astp = false,
			async, pid, _entry, _res;
	dlvars	_flags = _int(pop_spawn_flags), _pid, _status;

	lconstant macro DEVIN = [weakref popdevin];

	define lconstant Spawn_arg(arg);
		lvars arg;
		if arg then arg@DSC_SPEC else _0 endif
	enddefine;

	dlocal 0 % false -> async,
			   if async then async -> weakref sys_async_io(DEVIN,RD_SET) endif
			 %;

	unless isboolean(will_do_wait) then
		((), command, input, output, wait, will_do_wait)
			-> (command, input, output, wait, will_do_wait, astp);
		Check_astp_arg(astp)
	endunless;

	if not(input) and testdef popdevin and testdef sys_async_io
	and (weakref sys_async_io(DEVIN,RD_SET) ->> async) then
		false -> weakref sys_async_io(DEVIN,RD_SET)
	endif;

	if command then consdescriptor(command) -> command endif;
	if input then consdescriptor(input) -> input endif;
	if output then consdescriptor(output) -> output endif;

	if wait then
		;;; waiting
		_flags _biclear _1 -> _flags;	;;; set wait mode (bit 0 = 0)

		if testdef popdevin then
			;;; disable Ctrl-C first
			Vms_set_Ctrl_C(DEVIN, false)
		endif;

		_extern lib\$spawn(
						/* command */	Spawn_arg(command),
						/* input   */	Spawn_arg(input),
						/* output  */	Spawn_arg(output),
						/* flags   */	ident _flags,
						/* prcnam  */	,
						/* pidadr  */	ident _pid,
						/* statadr */	ident _status) -> _res;

		if testdef popdevin then
			;;; re-enable Ctrl-C before returning
			Vms_set_Ctrl_C(DEVIN, true)
		endif;
		if _res _bitst _1 then
			;;; succeeded
			return(	Uint_->_bigint(_pid),		;;; return pid ...
					Uint_->_bigint(_status))	;;; ... and status
		endif

	else
		;;; not waiting
		_flags _biset _1 -> _flags;		;;; set nowait mode (bit 0 = 1)

		;;; find free entry in proc table
		_vmsproc_tab -> _entry;
		repeat
			if _entry >=@(struct PROC_ENTRY) _vmsproc_tab_lim then
				mishap(0, 'sys_spawn: NO SPACE LEFT IN PROCESS TABLE')
			endif;
			quitif(_zero(_entry!PROC_COND));
			_entry@(struct PROC_ENTRY)++ -> _entry
		endrepeat;

		_extern lib\$spawn(
						/* command */	Spawn_arg(command),
						/* input   */	Spawn_arg(input),
						/* output  */	Spawn_arg(output),
						/* flags   */	ident _flags,
						/* prcnam  */	,
						/* pidadr  */	_entry@PROC_PID,
						/* statadr */	_entry@PROC_STATUS,
						/* efn     */	,
						/* astadr  */	_extern _pop_spawn_ast,
						/* astpar  */	_entry@PROC_COND)
			-> _res;
		if _res _bitst _1 then
			;;; succeeded -- set live process in table (_spawn_ast will
			;;; set PROC_COND to -1 when the process dies)
			_1 -> _entry!PROC_COND;
			Uint_->_bigint(_entry!PROC_PID) -> pid;
			Add_os_process_entry(will_do_wait, astp, pid);
			return(pid)						;;; return pid
		endif
	endif;

	;;; come here if failed
	Syserr_mishap(0, 'CAN\'T SPAWN SUB-PROCESS')
enddefine;

endsection;     /* $-Sys */
