/* --- Copyright University of Sussex 1990. All rights reserved. ----------
 > File:            C.vms/src/sysattach.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *SYSUTIL
 */

;;; ------------------- ATTACH TO A PROCESS ------------------------------

#_INCLUDE 'declare.ph'

global constant
		procedure Sys$-Vms_set_Ctrl_C
	;

;;; ----------------------------------------------------------------------

section $-Sys => sysattach syskill;

	;;; attach to a process
define sysattach(pid) -> bool;
	lvars pid, bool;
	dlvars _pid = Pint_->_uint(pid, _-1);

	Vms_set_Ctrl_C(popdevin, false);	;;; disable Ctrl-C first
	;;; returns true if successful
	_extern lib\$attach(/* pidadr */ ident _pid) _bitst _1 -> bool;
	Vms_set_Ctrl_C(popdevin, true)		;;; re-enable Ctrl-C before returning
enddefine;

	;;; kill a process
define syskill(pid);
	lvars pid;
	dlvars _pid = Pint_->_uint(pid, _-1);
	;;; returns true if successful
	_extern sys\$delprc(/* pidadr */ ident _pid,
						/* prcnam */ )
		_bitst _1
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 10 1990
		VMS _extern changed to return proper system call result (thus test
		for success is now result _bitst _1).
--- John Gibson, Apr 15 1988
		Moved out of sysutil.p
 */
