/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/objectclass/src/seq_to_closure.p
 > Purpose:         Objectclass file
 > Author:          Steve Knight, HP Labs, 1992-1993
 > Documentation:   HELP OBJECTCLASS
 > Related Files:
 */
section $-objectclass;

;;; Is p a version of apply (or fast_apply) or a (recursive) empty
;;; closure of apply?
define lconstant procedure Is_apply( p ); lvars p;
	p == apply or
	p == fast_apply or
	p.isclosure and p.datalength == 0 and p.pdpart.Is_apply
enddefine;

;;; Implementation note:
;;;     We use -A- to stash the outermost procedure into the
;;;     pdprops of all the closures.  That way we can easily get hold
;;;     of the underlying action.  The point of this is that we can
;;;     define -wrapper_deref- without difficulty or resorting to
;;;     (relatively) expensive property tables.
;;;
define lconstant procedure seqclose( A, W ) ; lvars A, W;
	if W.null then
		A
	else
		lvars p = W.dest -> W;
		if p.Is_apply then              ;;; optimise out simple appliers.
			seqclose( A, W )
		else
			lvars c = p(% seqclose( A, W ) %);
			A -> c.pdprops;
			c
		endif;
	endif
enddefine;

define seq_to_closure( A, W ) -> R; lvars A, W, R;
	seqclose( A, W ) -> R;
	unless R == A do
		A.pdprops -> R.pdprops;
		A.pdnargs -> R.pdnargs;
	endunless;
enddefine;

endsection;

;;; -------------------------------------------------------------------------
;;; Modified, 2/7/93, sfk
;;;     *   Arranged for the result of seq_to_closure to have the same
;;;         pdprops and pdnargs as the ``innermost'' procedure.  This
;;;         simplifies nearly all of the uses of seq_to_closure.
;;; -------------------------------------------------------------------------
