/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 > File:            C.power/src/array_cons.p
 > Purpose:
 > Author:          John Gibson, Apr 17 1998
 > Related Files:   C.power/src/ass.p, C.all/src/arrays.p
 */

;;; ------------- CONSTRUCTING ARRAY PROCEDURES (POWER) --------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'drop_code.ph'

constant
		_array_sub
	;


;;; ---------------------------------------------------------------------

section $-Sys$-Vm;

	/*	Construct a raw array procedure. _________tabsize is the word offset size of
		the array params starting at PD_ARRAY_TABLE.
	*/
define $-Sys$-Array$-Cons(_tabsize) -> _arrayp;
	lvars _tabsize, _arrayp, _drop_ptr, _size, _rtn;

	;;; macro for dropping instructions
	lconstant macro _CODE = [_drop_ptr!(code)++ -> _drop_ptr];

	;;; get procedure record -- 11 instructions
	@@PD_ARRAY_TABLE{_tabsize} _add @@(w)[_11 | code.r] _sub @@POPBASE
										-> _size;
	Get_store(_size) -> _arrayp;

	;;; initialise some of procedure header
	##(w){_size} -> _arrayp!PD_LENGTH;
	_0		->> _arrayp!PD_REGMASK
			->> _arrayp!PD_NUM_STK_VARS
			->> _arrayp!PD_NUM_PSTK_VARS
			->> _arrayp!PD_NLOCALS
			-> _arrayp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _arrayp!PD_GC_OFFSET_LEN;
	lconstant _flen = ##SF_LOCALS _sub ##SF_RETURN_ADDR;	;;; = 2
	_flen -> _arrayp!PD_FRAME_LEN;

	;;; start of code
	_arrayp@PD_ARRAY_TABLE{_tabsize} ->> _drop_ptr -> _arrayp!PD_EXECUTE;

	;;; create stack frame and load _array_sub address into count reg
	_array_sub -> _rtn;
	_D_inst(_OP_ldah, _:RGt0, _shift(_rtn, _-16), _0)			-> _CODE;
	_XFX_inst(_OP_mfspr, _SPR_LR, _:RGt1)						-> _CODE;
	_D_inst(_OP_ori, _:RGt0, _rtn, _:RGt0)						-> _CODE;
	_D_inst(_OP_stWu, _:RGpb, @@(w)-[_flen], _:RGsp)			-> _CODE;
	_XFX_inst(_OP_mtspr, _SPR_CTR, _:RGt0)						-> _CODE;
	_D_inst(_OP_stW, _:RGt1, @@SF_RETURN_ADDR[_flen], _:RGsp)	-> _CODE;

	;;; call _array_sub
	;;; (picks up parameters from PB+PD_ARRAY_TABLE, stacks computed
	;;; subscript and PD_ARRAY_VECTOR, and then chains PD_ARRAY_SUBSCR_PDR)
	_X_inst(_OP_bcctrl, _BO_ALWAYS, _0, _0)						-> _CODE;

	;;; exit code
	_drop_ptr -> _arrayp!PD_EXIT;			;;; pointer to exit code
	_D_inst(_OP_ldW, _:RGt1, @@SF_RETURN_ADDR[_flen], _:RGsp)	-> _CODE;
	_D_inst(_OP_ldWu, _:RGpb, @@(w)[_flen], _:RGsp)				-> _CODE;
	_XFX_inst(_OP_mtspr, _SPR_LR, _:RGt1)						-> _CODE;
	_X_inst(_OP_bclr, _BO_ALWAYS, _0, _0)						-> _CODE;
enddefine;

endsection;			/* $-Sys$-Vm */
