/* --- Copyright University of Sussex 1999. All rights reserved. ----------
 > File:			S.powaix/src/syscomp/asmout.p
 > Purpose:
 > Author:			John Gibson, Jan 15 1998 (see revisions)
 */


/* -------------------------------------------------------------------------

				  OUTPUT CODE PROCEDURES (POWER/AIX)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas;

constant macro $-WORD_SHIFT = integer_length(WORD_OFFS)-1;

	;;; popints are shifted left to accord with word scaling
define popint(n); lvars n; (n<<WORD_SHIFT) || 2:11 enddefine;
define mcint(n); lvars n; n >> WORD_SHIFT enddefine;


vars	nextlabel;

define nextlab();
	dlocal pop_pr_radix = 36;
	'L' >< nextlabel;
	nextlabel fi_+ 1 -> nextlabel
enddefine;

define lconstant asm_label(word, prefix_char);
	lvars n, len, string, q, r, prefix_char, word;
	lconstant SEP_CHAR = `.`;
	if isstring(word) then word else fast_word_string(word) endif -> string;
	datalength(string) -> len;
	cons_with consstring {%
		prefix_char, SEP_CHAR;
		fast_for n to len do
			go_on dup(fast_subscrs(n, string)) to
			;;; 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6
				c c c c c c c c c c c c c c c c		;;; Ctrl-A -- Ctrl-P
				c c c c c c c c c c c c c c c c		;;; Ctrl-Q -- SPACE
				s s s $ s s s s s s s s s s s d		;;;   !    --   0
				d d d d d d d d d s s s s s s s		;;;   1    --   @
				A A A A A A A A A A A A A A A A		;;;   A    --   P
				A A A A A A A A A A s s s s u s		;;;   Q    --   `
				a a a a a a a a a a a a a a a a		;;;   a    --   p
				a a a a a a a a a a s s s s c c		;;;   q    -- \(128)
			else c;

			A: a: d: u :		;;; alpha, digit, underscore
				nextloop;

			$ :
				if n /== len and fast_subscrs(n fi_+ 1, string) == `-`
				and (n /== 1 or len fi_> 2) then
					;;; replace section separator $- with SEP_CHAR
					-> ;			;;; erase $
					unless n == 1 then SEP_CHAR endunless;
					n fi_+ 1 -> n;	;;; skip -
					nextloop
				;;; else drop thru to "s"
				endif;

			s: c:				;;; other sign, control etc
				;;; represent as 3 decimal digits
				() fi_// 100 -> q -> r;
				q fi_+ `0`;
				r fi_// 10 -> q -> r;
				q fi_+ `0`, r fi_+ `0`;

		endfast_for
	%}
enddefine;

constant procedure (
	asm_symlabel	= asm_label(%`c`%),
	asm_identlabel	= asm_label(%`i`%),
	asm_wordlabel	= asm_label(%`w`%),
	asm_wordidlabel	= asm_label(%`z`%),
	asm_pdpropslabel= asm_label(%`p`%),
	asm_testdeflabel= asm_label(%`t`%),
	);


	;;; list of pop symbol prefixes for use by -Extern_make_base-
	;;; see unixextern.p
constant macro (
	$- POP_SYMBOL_PREFIXES =
		[['c.' 'xc.' 'uc.' 'xuc.' 'i.' 'w.' 'z.' 'p.' 't.' '_end\^@']],

	$- ASM_TEXT_STR		= '\t.csect[PR]',
	$- ASM_DATA_STR		= '\t.csect[RW]',
	$- ASM_BYTE_STR		= '\t.byte\t',
	$- ASM_SHORT_STR	= '\t.short\t',
	$- ASM_INT_STR		= '\t.long\t',
	$- ASM_DOUBLE_STR	= '\t.quad\t',

	$- ASM_WORD_STR = #_IF WORD_BITS == DOUBLE_BITS ASM_DOUBLE_STR
					  #_ELSE						ASM_INT_STR
					  #_ENDIF,

	$- ASM_CODE_PSECT	= '\t.csect[PR]\n',
	;;; [RO] gets put in the text seg and is no use
	$- ASM_NWRIT_PSECT	= '\t.csect NW_CSECT[RW], 3\n',
	$- ASM_DATA_PSECT	= '\t.csect[RW], 3\n',
	);


#_IF DEF POPC
vars 	current_asm_segment, asm_seg_offsets,
		procedure (asm_label_offsets, pdr_literal_label);

constant procedure (out_objmod_pad, perm_const_lab);

define asm_label_diff(lab1, lab2);
	lvars lab1, lab2, offs1, offs2, diff;
		(asm_label_offsets(lab1) ->> offs1)
	and (asm_label_offsets(lab2) ->> offs2)
	and (offs1 - offs2 ->> diff) && 3 == 0		;;; i.e same aeg
	and diff >> 2
enddefine;
#_ENDIF

constant
	asmseg_nonwriteable = ASMSEG_NONWRITEABLE,
	asmseg_code			= ASMSEG_CODE,
;

define asm_startcode = outcode(%'\n'<>ASM_NWRIT_PSECT%) enddefine;
define asm_startdata = outcode(%'\n'<>ASM_DATA_PSECT%) enddefine;
define asm_startinstr = outcode(%'\n'<>ASM_CODE_PSECT%) enddefine;

lvars nwsizelab;

define lconstant output_lab(lab, globl);
	lvars lab, globl;
	if globl then
		asmf_charout('.globl '), asmf_charout(lab), asmf_charout(`\n`)
	endif;
	asmf_charout(lab), asmf_charout(`:`), asmf_charout(`\n`);

#_IF DEF POPC
	returnunless(current_asm_segment);		;;; i.e. if doing .s file
	(subscrv(current_asm_segment,asm_seg_offsets) << 2) || current_asm_segment
				-> asm_label_offsets(lab)
#_ENDIF
enddefine;
;;;
define asm_outlab  = output_lab(% false %) enddefine;
define asm_outglab = output_lab(% true %) enddefine;

define lconstant pr_item(item);
	lvars item, tmp;
	if isstring(item) and datalength(item) fi_> 18
	and isnumbercode(fast_subscrs(1,item)) and (strnumber(item) ->> tmp)
	then
		tmp -> item
	endif;
	if isbiginteger(item) and integer_length(item)==64 then
		dlocal pop_pr_radix = 16;
		asmf_printf(item, '0x%p');
	else
		asmf_pr(item)
	endif;
enddefine;

define lconstant labset(lab, val, globl);
	lvars lab, val, globl, offs;
	if globl then
		asmf_charout('.globl '), asmf_charout(lab), asmf_charout(`\n`)
	endif;
	asmf_printf(lab, '.set %p, ');
	pr_item(val);
	asmf_charout(`\n`);

#_IF DEF POPC
	returnunless(current_asm_segment);		;;; i.e. if doing .s file
	if asm_label_offsets(val) ->> offs then
		offs -> asm_label_offsets(lab)
	endif
#_ENDIF
enddefine;
;;;
define asm_outlabset  = labset(% false %) enddefine;
define asm_outglabset = labset(% true %) enddefine;


define lconstant outdatum(n, string, offs);
	lvars m, n, string, offs;

	returnif(n == 0);
	asmf_charout(string);
	fast_for m from n by -1 to 2 do
		pr_item(subscr_stack(m)), asmf_charout(`,`)
	endfast_for;
	pr_item();
	erasenum(n-1);
	asmf_charout(`\n`);

#_IF DEF POPC
	subscrv(current_asm_segment,asm_seg_offsets) fi_+ (n fi_* offs)
				-> subscrv(current_asm_segment,asm_seg_offsets)
#_ENDIF
enddefine;
;;;
define asm_outbyte	= outdatum(% ASM_BYTE_STR,  BYTE_OFFS %) enddefine;
define asm_outshort	= outdatum(% ASM_SHORT_STR, SHORT_OFFS %) enddefine;
define asm_outint	= outdatum(% ASM_INT_STR,   INT_OFFS %) enddefine;
define asm_outword	= outdatum(% ASM_WORD_STR,  WORD_OFFS %) enddefine;
define asm_outdouble = outdatum(% ASM_DOUBLE_STR, DOUBLE_OFFS %) enddefine;


define lconstant do_align(aoffs);
	lvars aoffs;
  #_IF DEF POPC
	;;; can't use .align because the disgusting assembler will relocate an
	;;; immediately preceding label to after the .align
	lvars pad = (aoffs - subscrv(current_asm_segment,asm_seg_offsets))
						mod aoffs;
	returnif(pad == 0);
	if testbit(pad, 0) then asm_outbyte(0, 1) endif;
	if testbit(pad, 1) then asm_outshort(0, 1) endif;
	if testbit(pad, 2) then asm_outint(0, 1) endif;
  #_ELSE
	outcode(integer_length(aoffs)-1, '.align %p');
  #_ENDIF
enddefine;

	;;; asm_align_word() -- output alignment for word
define asm_align_word = do_align(% WORD_OFFS %) enddefine;

	;;; asm_align_double() -- output alignment for double (e.g. double float)
define asm_align_double = do_align(% DOUBLE_OFFS %) enddefine;


	;;; asm_out_dfloat(_______hi_part, _______lo_part) -- output double float
define asm_out_dfloat	= asm_outint(% 2 %) enddefine;

	;;; asm_align_file() -- output end-of-file alignment
	;;; (don't define if no alignment necessary)
;;; define asm_align_file(); enddefine;

define asm_startfile(a_name);
	lvars a_name;
	asm_startcode();		;;; ensures csect NW_CSECT is put first
#_IF DEF POPC
	{% 0, 0, 0 %} -> asm_seg_offsets;
	newproperty([], 64, false, "perm") -> asm_label_offsets;
	newmapping([], 32, false, false) -> pdr_literal_label;

	ASMSEG_NONWRITEABLE -> current_asm_segment;
	out_objmod_pad(-1);
	0 -> subscrv(ASMSEG_NONWRITEABLE,asm_seg_offsets);
	nextlab() -> nwsizelab;
	;;; RAW_SIZE, KEY
	asm_outword(nwsizelab, perm_const_lab([Sys nonwriteable_rawstruct_key]), 2);
#_ENDIF
enddefine;

define asm_endfile();
#_IF DEF POPC
	asm_startcode();
	ASMSEG_NONWRITEABLE -> current_asm_segment;
	asm_align_word();
	asm_outlabset(nwsizelab, subscrv(ASMSEG_NONWRITEABLE,asm_seg_offsets));
	out_objmod_pad(0)
#_ENDIF
enddefine;


#_IF DEF POPC and DEF ASM_STRUCT_WRAP_BUG
	/*	This is needed because the abysmal assembler produces a corrupt
		object file for .long _____label where _____label is later defined as
		absolute (ie set to an integer)
	*/
define asm_struct_wrap(keylab, code_p_list);
	lvars	keylab, code_p_list, code_p, save_charout = asmf_charout,
			init_offset = subscrv(current_asm_segment,asm_seg_offsets),
			size;
	dlocal	asmf_charout = erase;

	;;; dummy run to get size
	asm_outword(0, 0, 2);
	fast_for code_p in code_p_list do code_p() endfor;

	subscrv(current_asm_segment,asm_seg_offsets) - init_offset -> size;
	init_offset -> subscrv(current_asm_segment,asm_seg_offsets);
	save_charout -> asmf_charout;

	;;; do it for real
	asm_outword(size, keylab, 2);		;;; RAW_SIZE, KEY
	fast_for code_p in code_p_list do code_p() endfor;
enddefine;
#_ENDIF


	/*	asm_addbits is used to accumulate a sequence of bitfields into
		a (big)integer which asm_outbits is then called to output when the
		total number of bits accumulated occupies an exact number of bytes.
			___val is the currently accumulated (big)integer, containing
		_____nbits bits so far; _______new_val is the field to be added, containing
		_________new_nbits bits.
			The value returned will be the ___val input for the next field
		(with _____nbits incremented by _________new_nbits), and so on. Other than
		initialising ___val to 0 at the start, nothing is assumed about how
		the fields are added to it, so it is the responsibility of this
		procedure and asm_outbits to output the bitfields correctly.
	*/
	;;; POWER ('big endian') version adds the fields at the bottom and
	;;; outputs the bytes from the top down
define asm_addbits(new_val, new_nbits, val, nbits);
	lvars new_val, new_nbits, val, nbits;
	(val << new_nbits) || new_val	;;; add the new field at the bottom
enddefine;

	/*	In this, _____nbits is a multiple of BYTE_BITS, and ___val has been
		produced by repeated calls of asm_addbits
	*/
define asm_outbits(val, nbits);
	lvars val, nbits, count = 0;
	lconstant BYTE_MASK = (1<<BYTE_BITS)-1;
	until nbits == 0 do
		nbits-BYTE_BITS -> nbits;
		(val >> nbits) && BYTE_MASK;	;;; output bytes from the top down
		;;; this just saves putting each byte on a separate line
		if (count+1 ->> count) == 12 then asm_outbyte(count), 0 -> count endif;
	enduntil;
	if count /== 0 then asm_outbyte(count) endif
enddefine;


	/*	Optional procedure used (if present) by Poplink
		to do more compact generation of strings using ".ascii"
	*/
define asm_quick_genstring(string);
	lvars c, n = 1, l = datalength(string), string;
	until n fi_> l do
		f_subs(n, string) -> c;
		returnif(c fi_< `\s` or c fi_> `~` or c == `\\` or c == `"`) (false);
		n fi_+ 1 -> n
	enduntil;
	asmf_charout('\t.string "');	;;; null-terminates string
	asmf_charout(string);
	asmf_charout(`"`), asmf_charout(`\n`);

	l + 1 -> l;						;;; account for added null
	if (l fi_&& (WORD_BYTES-1) ->> l) /== 0 then
		WORD_BYTES - l -> l;
		asm_outbyte(dupnum(0, l), l)
	endif;
	"null"		;;; means string is already null-terminated
enddefine;

	/*	For closures generated by Poplink for undef procedures
	*/
define asm_gen_poplink_code(outlabs, nfroz, jmplab);
	lvars offs, outlabs, nfroz, jmplab;
#_IF WORD_BITS==DOUBLE_BITS
#_ELSE
	lconstant macro (ldW = 'lwz', stWu = 'stwu');
#_ENDIF
	lconstant macro (PD_CLOS_PDPART = WORD_OFFS*2 + INT_OFFS*2,
					 PD_CLOS_FROZVALS = PD_CLOS_PDPART + WORD_OFFS);
	asm_startinstr();
	outlabs();						;;; plant exec labels
	0 -> offs;
	fast_repeat nfroz times
		outcode(PD_CLOS_FROZVALS+offs, ldW, '%p\t0, %p(15)');	;;; 15=pb
		offs+WORD_OFFS -> offs;
		outcode(WORD_OFFS, stWu, '%p\t0, -%p(12)')				;;; 12=usp
	endrepeat;
	outcode(PD_CLOS_PDPART, ldW, '%p\t15, %p(15)');
	outcode(ldW, '%p\t0, 0(15)');
	outcode('mtctr\t0');
	outcode('bctr');
	asm_startcode();				;;; back to nonwriteable data
	0			;;; nothing planted in closure header
enddefine;

/*
 *	Exfunc closure code -- jump to subroutine _exfunc_clos_action (aextern.s)
 *	with exfunc_closure record address in a reg, etc. This procedure is
 *	passed the label of _exfunc_clos_action. The code generated must be
 *	padded to exactly 16 bytes.
 */

define asm_gen_exfunc_clos_code(action_lab);
#_IF WORD_BITS==DOUBLE_BITS
#_ELSE
	;;; 'code' is a 3-word procedure descriptor (padded to 4 words).
	;;; 1st word (execute address) is _exfunc_clos_action, 2nd word
	;;; is pointer to record itself (loaded into TOC reg when
	;;; the thing is called)
	lvars lab = nextlab();
	asm_outlab(lab);
	asm_outword(action_lab, lab, 0, 0, 4);
#_ENDIF
enddefine;


/*
 *	extern_name_translate:
 *		translate an external symbol, using the same conventions as the
 *		C compiler and linker (e.g. add a leading '_', truncate to N
 *		characters, etc.)
 */

define extern_name_translate(lang, symbol, type) -> symbol;
	lvars lang, symbol, type;
	if lang = 'FORTRAN' then uppertolower(symbol) <> '_' -> symbol endif
enddefine;


	/* Stuff used in os_comms.p
	*/
constant

	;;; location of crt*.o files for linking
	unix_ld_crt_objects = '/lib/crt0.o',

	;;; Assembler command line arguments
	unix_as_options = ['-u'],
;

	;;; String for first line of Unix "ld" command
	;;; (Image name is in the variable "IM")
define active unix_ld_command_header;
	'/bin/ld -o $IM -brtl -bexpall -bnoobjreorder -bpT:0x10000000 -bpD:0x20000000 \\\n';
	lconstant exports_file = '$popexternlib/exports';
	if sys_file_exists(exports_file) then
		() <> '-bexport:' <> sysfileok(exports_file) <> ' \\\n'
	endif;
enddefine;


endsection;		/* $-Popas */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Feb 18 1999
		Changed unix_ld_command_header to allow for an explicit exports file
 */
