/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.powaix/src/syscomp/sysdefs.p
 > Purpose:
 > Author:          John Gibson, Jan 15 1998
 */

/* -------------------------------------------------------------------------

				DEFINITIONS FOR MACHINE/OPERATING SYSTEM

--------------------------------------------------------------------------*/

section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; --- SYSTEM NAME -----------------------------------------------------

	MACHINE			= [[power]],


;;; --- MACHINE = POWER[PC] -----------------------------------------------

	PROCESSOR		= [[power]],	;;; type of cpu
	POWER			= true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	BIG_ENDIAN		= true,
	STACK_ALIGN_BITS= 64,			;;; alignment in bits for stack frames


;;; -- OPERATING SYSTEM = AIX -------------------------------------------

	UNIX			= true,
	AIX				= 4.2,
	POSIX1			= 199009,
	POSIX2			= 199209,
	OPERATING_SYSTEM = [[unix aix ^AIX posix {^POSIX1 ^POSIX2}]],	;;; type of os

	;;; Feature list
	BERKELEY		= 4.3,
	BSD_MMAP		= true,			;;; has mmap and mprotect facilities
	BSD_MPROTECT	= true,
	SHARED_LIBRARIES = true,		;;; dynamically linked against shared libraries
	COFF			= true,

	VPAGE_OFFS		= 16:1000,		;;; word address offset of a virtual page
	SEGMENT_OFFS	= VPAGE_OFFS,	;;; word address offset of a segment
	LOWEST_ADDRESS	= false,		;;; false is the lowest pop struct
	LOWEST_CODE_ADDRESS	= 16:10000000,
	UNIX_USRSTACK	= 16:2FF23000,	;;; end of stack (as USRSTACK in <sys/vmparam.h> etc)

	;;; Procedures to get and set the memory break and return the end of
	;;; memory. This uses _pop_sbrk and _pop_brk, which are implemented in
	;;; terms of own versions of mmap and munmap that keep a record of
	;;; the 'break', i.e. the highest addess allocated.

	GET_REAL_BREAK =
		[procedure(); _extern _pop_sbrk(_0)@(b.r->vpage) endprocedure],

	SET_REAL_BREAK =
		[procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern _pop_brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif
		endprocedure],


;;; --- OTHER ------------------------------------------------------------


	;;; C returns "float" as double
	C_FLOAT_RESULT_SINGLE = false,

	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; if GEN_SVB_CONSTANTS is true, constants in _special_var_block will be
	;;; generated by Poplink, and recognised in the production of M-code
	;;; operands by Popc (providing genproc.p defines SPECIAL_VAR_BLOCK_REG).

	GEN_SVB_CONSTANTS	= true,

);

define :inline CACHEFLUSH(_ptr, _nbytes);
	if $-Sys$- _cache_flush_needed then
		$-Sys$- _cache_flush(_ptr, _nbytes)
	endif
enddefine;

endsection;		/* $- */
