/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:            C.all/lib/lib/mkind.p
 > Purpose:         Pop11 "script" for building index of procedure definitions
 > Author:          John Williams, Sep 16 1992 (see revisions)
						(original by Chris Slymon, June 1983)
 > Documentation:   HELP * POPINDEX, HELP * SOURCEFILE
 > Related Files:   C.unix/com/mkind, C.vms/com/mkind.com
						LIB * BUILDINDEX, LIB * POPINDEX
 */

#_TERMIN_IF not(pop_runtime)

section;

/* Set the lvar ____________Preserve_env false if index entries should NOT include
	unexpanded environment variables (e.g. $usepop) in filenames
*/

lvars Preserve_env = true;


/* Set up list of directories to index */

global vars popindexlist;

uses popxlib;       ;;; Ensure X directories are added to the searchlists

define lconstant Convert_searchlist(list, patt);
	lvars item list patt;
	for item in flatten_searchlist(list, false) do
		item dir_>< patt
	endfor
enddefine;

unless islist(popindexlist) do
	[%
		/* Main source, library, and include directories */

		Convert_searchlist(vedsrclist, '*.p'),
		Convert_searchlist(popuseslist, '*.p'),
		Convert_searchlist('$popsrc' :: popincludelist, '*.ph'),

		/* Other directories below $usepop/pop/lib */

		'$usepop/pop/lib/flavours/*.p',
		'$usepop/pop/lib/lr_parser/.../*.p',
		'$usepop/pop/lib/objectclass/.../*.p',

		/* Subsystem library directories */

		'$usepop/pop/lisp/flib/*.p',
		'$usepop/pop/plog/auto/*.p',
		'$usepop/pop/plog/lib/*.p',

		/* X directories not covered by popxlib */

		'$usepop/pop/x/pop/lib/X11/*.p',
		'$usepop/pop/x/pop/lib/Xaw/*.p',
		'$usepop/pop/x/pop/lib/Xm/*.p',
		'$usepop/pop/x/pop/lib/Xol/*.p',
		'$usepop/pop/x/pop/lib/Xpw/*.p',
		'$usepop/pop/x/pop/lib/xlib/*.p',
		'$usepop/pop/x/ui/lib/*.p',
		'$usepop/pop/x/ved/.../*.p',

	%] -> popindexlist
endunless;


/* Now create the index */

#_IF sys_fname_nam(poparg1) = 'mkind'

	500000 ->> popmemlim -> popminmemlim;
	1 -> pop_file_versions;

	uses buildindex;        ;;; Defines buildindex
	uses popindex;          ;;; Defines popindex_filename

	sysgarbage();
	sys_lock_heap();

	popindexlist ==>
	popindex_filename ==>

	buildindex(popindexlist, popindex_filename, Preserve_env);

#_ENDIF


endsection;


/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Dec  6 1995
		Added various missing directories and removed plog/src (already
		included in vedsrclist)
--- John Gibson, Nov  9 1995
		Removed pw*m dir
--- John Williams, Apr 30 1993
		Now does sys_lock_heap explicitly, rather than inside the call to
		buildindex.
--- John Gibson, Oct 21 1992
		Added #_TERMIN_IF at top of file so does nothing if not(pop_runtime)
		(e.g. when compiled with popc)
 */
