/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 > File:			C.power/src/asm.ph
 > Purpose:			Include file for .s files
 > Author:			John Gibson, Feb  6 1998
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'registers.ph'

define :inline lconstant REGNAME(reg=item);
	REG_PREFIX sys_>< reg
enddefine;

define :inline lconstant FREGNAME(freg=item);
	FREG_PREFIX sys_>< freg
enddefine;

#_IF WORD_BITS==DOUBLE_BITS
lconstant macro (WORD_SUFFIX = 'q', \.WORD = '.quad');
#_ELSE
lconstant macro (WORD_SUFFIX = 'l', \.WORD = '.long');
#_ENDIF


lconstant macro (
	rt0		= REGNAME(RGt0),
	rt1		= REGNAME(RGt1),
	rt2		= REGNAME(RGt2),
	rt3		= REGNAME(RGt3),
	rt4		= REGNAME(RGt4),
	rt5		= REGNAME(RGt5),
	rt6		= REGNAME(RGt6),
	rt7		= REGNAME(RGt7),

	rpl0	= REGNAME(RGpl0),
	rpl1	= REGNAME(RGpl1),
	rpl2	= REGNAME(RGpl2),
	rpl3	= REGNAME(RGpl3),
	rpl4	= REGNAME(RGpl4),
	rpl5	= REGNAME(RGpl5),
	rpl6	= REGNAME(RGpl6),
	rpl7	= REGNAME(RGpl7),
	rpl8	= REGNAME(RGpl8),
	rpl9	= REGNAME(RGpl9),
	rpl10	= REGNAME(RGpl10),

	rnpl0	= REGNAME(RGnpl0),
	rnpl1	= REGNAME(RGnpl1),
	rnpl2	= REGNAME(RGnpl2),
	rnpl3	= REGNAME(RGnpl3),
	rnpl4	= REGNAME(RGnpl4),

	rfalse	= REGNAME(RGfalse),
	rsvb	= REGNAME(RGsvb),
	rusp	= REGNAME(RGusp),
	rchain	= REGNAME(RGchain),
	rpb		= REGNAME(RGpb),
	rsp		= REGNAME(RGsp),
	rtoc	= REGNAME(RGtoc),

	ra0		= REGNAME(3),		;;; first 6 args to external calls
	ra1		= REGNAME(4),
	ra2		= REGNAME(5),
	ra3		= REGNAME(6),
	ra4		= REGNAME(7),
	ra5		= REGNAME(8),

	ft0		= FREGNAME(0),
	ft1		= FREGNAME(13),
	ft2		= FREGNAME(12),

	R0		= '0',
	R11		= '11',
	R12		= '12',
	CR0		= '0',
	CR1		= '1',
	CR2		= '2',
	CR3		= '3',
	CR4		= '4',
	CR5		= '5',
	CR6		= '6',
	CR7		= '7',
	Clt		= '0',
	Cgt		= '1',
	Ceq		= '2',
	Cso		= '3',

	_WOFFS			= @@(w)++,
	_TRUEOFFS		= @@(struct BOOLEAN)++,

	_KEY			= @@KEY,
	_K_APPLY		= @@K_APPLY,
	_RF_CONT		= @@RF_CONT,
	_PD_EXECUTE		= @@PD_EXECUTE,
	_PD_EXIT		= @@PD_EXIT,
	_PD_UPDATER		= @@PD_UPDATER,
	_P_BACK			= @@P_BACK,
	_P_FRONT		= @@P_FRONT,
	_SF_OWNER		= @@SF_OWNER,
	_SF_RETURN_ADDR	= @@SF_RETURN_ADDR,
	_V_BYTES		= @@V_BYTES,
	_PD_FRAME_LEN	= @@PD_FRAME_LEN,

	_svb_FALSE			= [_SVB_OFFS(false)(rsvb)],
	_svb_SAVED_SP		= [_SVB_OFFS(Sys$-Extern$- _saved_sp)(rsvb)],
	_svb_SAVED_USP		= [_SVB_OFFS(Sys$-Extern$- _saved_usp)(rsvb)],
	_svb_INVOC_FP		= [_SVB_OFFS(Sys$-Extern$- _invocation_fp)(rsvb)],
	_svb_IN_USER_EXTERN	= [_SVB_OFFS(Sys$- _in_user_extern)(rsvb)],

	ldW		= 'lwz',
	ldWu	= 'lwzu',
	stW		= 'stw',
	stWu	= 'stwu',
	cmpW	= 'cmpw',
	cmpWi	= 'cmpwi',
	cmplW	= 'cmplw',
	cmplWi	= 'cmplwi',
);

define lconstant macro INIT_POP_REGISTERS;
	lvars n;
	for n from 0 to 10 do
		[\t	mr \t	%consword('rpl'><n)%, rfalse \n ].dl
	endfor
enddefine;


lconstant macro (
	ASM_ALIGN_QUAD	= '\t.align\t3',
	ASM_START_FILE	= '',
	ASM_END_FILE	= '',
);
