/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/src/syscomp/wdefs.ph
 > Purpose:
 > Author:          John Gibson, Dec 24 1987 (see revisions)
 */

/* -------------------------------------------------------------------------

				DEFINITIONS FOR POPC, POPLINK, POPLIBR

--------------------------------------------------------------------------*/


iconstant macro (
	;;; number of bytes in wfile/wlib int values
	WINT_BYTES		= 4,

	;;; file extensions
	ASM_EXTENSION	= '.a',
	W_EXTENSION 	= '.w',
	OBJ_EXTENSION	= '.o',
	WLB_EXTENSION	= '.wlb',
	OLB_EXTENSION	= '.olb',
	STANDARD_WLIB_NAME = 'src.wlb',

	;;; magic numbers for .w files and libraries
	WFILE_MAGIC		= 36:WFILE,		;;; .w file
	WLIBR_MAGIC		= 36:WLIBR,		;;; .w library

	;;; file format version numbers
	CURRENT_WFILE_VERSION = 0,
	CURRENT_WLIBR_VERSION = 0,


	;;; record types and field subscripts on the .w file

			;;; type field is first in every record
			WR_TYPE			= 1,

	;;; quoted word
	WRTYPE_WORD			= 1,
			WRWORD_NAME		= 2,

	;;; section
	WRTYPE_SECT			= 2,
			WRSECT_FLAGS	= 2,
			WRSECT_PATHNAME	= 3,	;;; section pathname

	;;; identifier
	WRTYPE_IDENT		= 3,
			WRI_IDTYPE		= 2,	;;; 3 bytes
			WRI_IDPROPS		= 5,	;;; 3 bytes
			WRI_REST		= 8,	;;; id name string, init string

	;;; word/ident/wordident assign
	WRTYPE_WORD_ASSIGN	= 4,
	WRTYPE_IDENT_ASSIGN	= 5,
	WRTYPE_WORDID_ASSIGN= 6,
			WRASS_LABEL		= 2,	;;; equivalent label string

	;;; import/export
	WRTYPE_IMPORT		= 7,
	WRTYPE_EXPORT		= 8,
			WRIMEX_NAME		= 2,

	;;; weak dependency
	WRTYPE_WEAK_DEPEND	= 9,
			WRWKDP_REST		= 2,	;;; section name string, id name string

	;;; incremental list values/sublist or property entry chain
	WRTYPE_LINK_INCR	= 10,
			WRINCR_FLAGS	= 2,	;;; flags byte
			WRINCR_PREC		= 3,	;;; precedence for list entry (2 bytes)
			WRINCR_NSTRINGS	= 5,	;;; count of info strings after id name
			WRINCR_REST		= 6,	;;; section name string, id name string,
									;;; init typed string for this module,
									;;; NSTRINGS-1 further typed strings

	;;; obj file & library arg strings from external load
	WRTYPE_EXLOAD_STRINGS= 11,
			WRSTRS_NSTRINGS	= 2,	;;; count of strings
			WRSTRS_REST		= 3,	;;; NSTRINGS strings

	;;; assignment of global label to unique struct generated by poplink
	;;; (i.e. false, true, [] , etc)
	WRTYPE_UNIQUE_ASSIGN= 12,
			WRUNIQ_NUMBER	= 2,	;;; number of unique struct
			WRUNIQ_LABEL	= 3,	;;; equivalent label string

	;;; Names of w-libraries used by this module
	WRTYPE_WLIB_STRINGS	= 13,
			;;; same as WRTYPE_EXLOAD_STRINGS


	;;; end of file
	WRTYPE_END			= 99,


	;;; flags in WRINCR_FLAGS
	WRINCRF_TYPE		= 2:11,		;;; type
	WRINCRF_WRITEABLE	= 2:1e2,	;;; for a list, make writeable
	WRINCRF_SUBLISTS	= 2:1e3,	;;; for a list, generate per-file sublists
	;;; types in WRINCRF_TYPE
	WRINCRT_PROPERTY	= 0,
	WRINCRT_LIST		= 1,
	WRINCRT_PROCEDURE	= 2,

	;;; w-library values
	MODTAB_PTR		= WINT_BYTES*2,	;;; after magic num and format version
	INDEX_PTR		= WINT_BYTES*3,
	INDEX_LEN		= 2048,

	;;; header info in library w-module
	WMH_NAME		= 1,		;;; name (a word)
	WMH_DATE		= 2,		;;; date (integral, as sys_real_time etc)
	WMH_VEC_LEN		= 2,


	;;; field subscripts for w-libary identifier index entries
	WLINDX_IDPROPS	= 1,		;;; 3-byte idprops/op prec
	WLINDX_PRMFLAGS	= 4,		;;; 1-byte perm flags
	WLINDX_MOD_NUM	= 5,		;;; 2-byte module number in which id initialised
	WLINDX_NAME_LEN	= 7,		;;; name length
	WLINDX_NAME		= 8,		;;; name chars
								;;; for incr ident, followed by incr info


	;;; typed string types
	TYPESTR_INT		= 1,
	TYPESTR_FLOAT	= 2,
	TYPESTR_CONST	= 3,
	TYPESTR_WORD	= 4,
	TYPESTR_IDENT	= 5,
	TYPESTR_WORDID	= 6,


	;;; Internal structures used by poplink and poplibr

	;;; Outer database (a vector)
	DBASE_SECT_PROP				= 1,
	DBASE_WEAK_DEPEND_PROP		= 2,
	DBASE_GENERAL_ASSIGN_PROP	= 3,
	DBASE_IDENT_ASSIGN_PROP		= 4,
	DBASE_WORDID_ASSIGN_PROP	= 5,
	DBASE_EXLOAD_STR_ACTION		= 6,
	DBASE_WLIB_STR_ACTION		= 7,
	DBASE_VEC_LEN				= 7,

	;;; Section structure (a vector)
	SECT_FLAGS			= 1,
	SECT_NAME			= 2,
	SECT_PATHNAME		= 3,
	SECT_SUPERSECT		= 4,
	SECT_SUBSECTS		= 5,
	SECT_WORD_INFO		= 6,
	SECT_WORD_IDENTS	= 7,
	SECT_IMPORTS		= 8,
	SECT_EXPORTS		= 9,
	SECT_LEVEL			= 10,
	SECT_LABEL			= 11,
	SECT_ID_LIST		= 12,
	SECT_VEC_LEN		= 12,

	;;; section flags
	SECF_RUN_TIME		= 2:1e0,
	SECF_GENERATE		= 2:1e1,
	SECF_HAS_DICT_IDS	= 2:1e2,

	;;; Word/identifier info structure (a vector)
	INFO_TYPE			= 1,
	INFO_IDPROPS		= 2,
	INFO_INIT			= 3,
	INFO_PATHNAME		= 4, INFO_IDENT_LAB	= 4,
	INFO_WORD			= 5, INFO_WORD_LAB	= 5,
	INFO_NEXT_INFO		= 6,
	INFO_VEC_LEN		= 6,

	);



/* --- Revision History ---------------------------------------------------
--- John Gibson, May 27 1993
		Added WRTYPE_WLIB_STRINGS etc
--- John Gibson, May 10 1993
		Added DBASE_EXLOAD_STR_ACTION
--- John Gibson, Oct 13 1992
		14.22 changes
--- John Gibson, Jul 21 1992
		popc version 14.21 changes
--- John Gibson, Jul 17 1989
		Version 13.66
--- John Gibson, Jan 29 1989
		New version of popc
--- John Gibson, Oct  9 1988
		Added WMH_ field subscripts
--- John Gibson, Feb  9 1988
		Various changes
 */
