/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_polyline.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 23rd Aug 1993
;;; File: go_polyline.p
;;; Author: Ben L.E. Rabau

compile_mode :pop11 +strict;

uses go_polygon;

;;; --------------------------------------------------------------------
;;; POLYLINE CLASS:

;;; INTRO: The go_polyline CLASS represents open polygons (see slot go_closed).
;;; INTRO: This is just a special case of the go_polygon class (see also
;;; INTRO: REF * GO_POLYGON).

define :class go_polyline;
	isa go_polygon;
	slot stored_go_regular == false;
;;; REF: A polyline is not a regular go_polygon.
	slot stored_go_closed  == false;
;;; REF: A polyline is not a closed go_polygon.
	slot stored_go_npoints ==     2;
;;; REF: Stored number of angles in the go_polyline.
	slot go_border         ==     4;
;;; REF: Sensitive area in pixels around arrow for the mouse.
enddefine;

;;;------------------------------------------------------
;;; RESTRICTIONS:

define :method updaterof go_closed( flag, lin :go_polyline );
lvars flag, lin;
;;; REF: BOOLEAN -> go_closed( POLYLINE );
;;; REF: Prevent closing of a polyline. If BOOLEAN is false then a mishap occurs.
;;; REF: This updater method ensures that only open polylines can exist.
;;; REF: POLYLINE is an instance of the go_polyline class (REF * GO_POLYLINE).
	if( flag ) then
		mishap('Cannot make a go_polyline go_closed for object:',
			   [^ datakey(lin) ]);
	endif;
enddefine;


;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_polyline = true;


/* --- Revision History --------------------------------------------
 * BR 23/08/93
 *     Removed go_lines_coords()...
 * BR 25/05/93
 *     Removed last argument from go_lines_coords()...
 * BR 07/05/93
 *     Changed go_transxyout() to no longer include the screen object (see
 *     LIB * GO_PANE)
 * BR 28/04/93
 *     Moved go_polyarrow class into separate file: go_polyarrow.p
 * BR 04/12/92
 *     Created to replace go_stroke.p (class stroke and class arrow).
 *     These new classes go_polyline and go_polyarrow work also for polylines!
 */
;;; eof
