/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_text.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 20th May 1993
;;; File: go_text.p
;;; Author: Ben L.E. Rabau

compile_mode :pop11 +strict;

uses go_screen_object;
uses go_labelled;

;;;----------------------------------------------------------------
;;; CLASS TEXT

;;; INTRO: The CLASS go_text is a special case of the go_labelled mixin.
;;; INTRO: It the most basic go_labelled object (see REF *GO_LABELLED).
;;; INTRO: The label will have its own position and dimensions. It behaves
;;; INTRO: like all other basic go_screen_object object-types. See also
;;; INTRO: REF * GO_SCREEN_OBJECT for more details.

define :class go_text;
	isa go_labelled go_screen_object;
enddefine;


define :method go_fgdraw( pane :go_pane, lab :go_text );
lvars pane, lab;
;;; REF: go_fgdraw( PANE, TEXT );
;;; REF: Draws the the label on the given pane using the foreground colour.
;;; REF: PANE is an instance of the go_pane class (see REF * GO_PANE).
;;; REF: TEXT is an instance of the go_text class (see REF * GO_TEXT).
	go_draw_label( pane, lab );
enddefine;

define :method go_bounding_width( lab :go_text );
lvars pane, lab;
;;; REF: go_bounding_width( TEXT ) -> INTEGER;
;;; REF: The label's width is also the object's width. Updating this doesn't
;;; REF: make a lot of sense!
;;; REF: TEXT is an instance of the go_text class (see REF * GO_TEXT).
	go_label_width( lab ) ->> stored_go_bounding_width( lab );
enddefine;

define :method go_bounding_height( lab :go_text );
lvars pane, lab;
;;; REF: go_bounding_width( TEXT ) -> INTEGER;
;;; REF: The label's width is also the object's width. Updating this doesn't
;;; REF: make a lot of sense!
;;; REF: TEXT is an instance of the go_text class (see REF * GO_TEXT).
	go_label_height( lab ) ->> stored_go_bounding_height( lab );
enddefine;


;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_text = true;

/* --- Revision History --------------------------------------------
 * BR 19/05/93
 *     Adapted go_bounding_[width/height] to update stored version
 * BR 14/05/93
 *     Moved the go_draw_label() method from go_labelled into go_text (this
 *     used to limit the label to the first half of the bounding_box).
 * BR 09/05/93
 *     Changed the class name go_label into go_text because of conflict
 *     with slot name go_label() and autloading problems.
 * BR 30/04/93
 *     Moved go_label class into separate file, see LIB * GO_LABELLED
 */
;;; eof
