@NEWMASTER@ C.all/lib/ved/ved_what.p johng Thu Aug  6 16:22:30 GMT 1987
16,18c
--- Aled Morris, Sep 16 1986
	Removed variable -vedwhat_abbreviate_forms- to speed up autoloading,
	and keep the code short.  So forms will always be abbreviated.
--- Aled Morris, Aug 26 1986
	This code extracted from VED_WHATS.P, to speed up compiling a bit.  The
	bulk has been rewritten to include abbreviations etc.
*/
.
14a
lconstant short_form = newproperty(
   [[actions                'Acts']
	[array                  'Array']
	[boolean                'Bool']
	[byte_struc             'Bstruc']
	[character				'Char']
	[datastructure          'Dstruc']
	[device                 'Dev']
	[external_procedure     'ExtPdr']
	[field_specifier        'Spec']
	[filename               'File']
	[integer                'Int']
	[integral               'Int']
	[key                    'Key']
	[label                  'Lab']
	[number                 'Num']
	[pattern                'Pattern']
	[procedure              'Pdr']
	[process                'Process']
	[reference              'Ref']
	[sequence               'Seq']
	[string                 'Str']
	[structure              'Struc']
	[vector                 'Vec']
	[vectorclass            'Vclass']
	[ved_file_structure     'VedFile']
   ], 31, false, true);

define lconstant abbr(str) -> str;
lvars other str ch;
	if islowercode(subscrs(1, str) ->> ch) then
		if short_form(consword(str)) ->> other then
			other -> str;
		else
			lowertoupper(ch) -> fast_subscrs(1, str);
		endif;
	endif
enddefine;

define lconstant shorten(str);
lvars   b,
		str,
		a   = 0,
		sep = false,
		;
	while (locchar(`|`, a fi_+ 1, str) ->> b) do
		if sep then sep else `|` -> sep endif;
		explode(abbr(substring(a fi_+ 1, b fi_- a fi_- 1, str)));
		b -> a;
	endwhile;
	if sep then sep endif;
	explode(abbr(substring(a fi_+ 1, if locchar(`:`, a fi_+ 1, str) ->> b then
										 b fi_- 1
									 else
										 datalength(str)
									 endif fi_- a, str)))
enddefine;

define lconstant isargnamehere(i);
lvars i;
	islowercode(i)   or isnumbercode(i)   or i == `"`
	/* is a datatype or a literal integer or quoted word */
enddefine;

define shorteninfo(call) -> call;
lvars   call,
		i   = 0,
		j,
		len = datalength(call),
		pos = 1,
		;
	cons_with consstring
	{%
		while (locchar(`<`, i fi_+ 1, call) ->> i) do
			explode(substring(pos, i fi_- pos, call));
			i -> pos;
			if  i /== len
			and isargnamehere(subscrs(i fi_+ 1, call))
			and (locchar(`>`, i fi_+ 2, call) ->> j) then
				j fi_+ 1 -> pos;
				shorten(substring(i fi_+ 1, j fi_- i fi_- 1, call));
			endif
		endwhile;
		explode(allbutfirst(pos fi_- 1, call));
	%} -> call;
enddefine;

global constant ved_what = ved_do_what(% false %);

endsection;     /* $-what */

.
13c
;;; Displaying the info
.
11c
section $-what => ved_what;
.
9c
uses ved_whats;
.
1,6c
/* --- Copyright University of Sussex 1986. All rights reserved. ---------
 | File:            $usepop/master/C.all/lib/ved/ved_what.p
 | Purpose:         Give sample call for given identifier
 | Author:          Aled Morris, John Williams, Feb 6 1986 (see revisions)
 | Documentation:   HELP * VED_WHAT
 | Related Files:   $usepop/master/C.all/lib/data/ved_what/...
 |					and LIB * VED_WHATS
.
@NEWMASTER@ johnw Wed Jan 3 14:07:08 GMT 1990
454,467c
		Moved into system (src/vdwhats.p)
 */
.
440,452d
438d
15,435d
13c
syssynonym("ved_what", "ved_?");
.
10d
6,7c
 > Related Files:	$usepop/pop/lib/data/ved_what/...
.
3,4c
 > Purpose:			Same as ved_?
 > Author:			Aled Morris, John Williams, Feb 6 1986 (see revisions)
.
1c
/* --- Copyright University of Sussex 1987. All rights reserved. ---------
.
@NEWMASTER@ johnw Wed Jan 3 17:04:38 GMT 1990
7c
					C.all/lib/data/ved_what/*
.
@NEWMASTER@ johnw Fri Oct 26 14:25:30 BST 1990
18,19d
13a
lvars
	line_buf        = false,    ;;; line buffer (set up when first called)
	;

lconstant
	LBLEN           =   256,    ;;; length of line buffer

	POPACTIVE       =   'popactive',
	POPEXTRA        =   'popextravars',
	POPMACS         =   'popmacros',
	POPSYNTAX       =   'popsyntax',
	POPPROCS        =   'popprocs',
	POPSYS          =   'popsysprocs',
	POPOPS          =   'popops',
	POPLIBS         =   'poplibprocs',
	POPVARS         =   'popvars',
	POPDATATYPES    =   'popdatatypes',

	PROLOGPROCS     =   'prologprocs',

	PWMPROCS        =   'pwmprocs',

	VEDPROCS        =   'vedprocs',
	VEDVARS         =   'vedvars',
	VEDCOMMS        =   'vedcomms',
	VEDLIBS         =   'vedlibprocs',

	POPLIBDIRS      =  ['$popautolib/' '$usepop/pop/lib/database/'],
	VEDLIBDIRS      =  ['$popvedlib/'],

	POPWHATDIR      =   '$popdatalib/ved_what/',
	POPWHATFILES    =  [^POPMACS ^POPSYNTAX ^POPPROCS ^POPSYS
						^POPOPS ^POPLIBS ^POPVARS ^POPACTIVE
						^PROLOGPROCS ^PWMPROCS
						^VEDPROCS ^VEDVARS ^VEDCOMMS ^VEDLIBS
						^POPEXTRA],
	POPFORMATFILES  =  [^POPDATATYPES ^POPEXTRA ^POPVARS ^POPACTIVE ^VEDVARS],
	;


define lconstant Choosefile(Word);
	lvars Props Word;
	if issubstring('prolog', 1, Word) then
		PROLOGPROCS
	elseif issubstring('pwm', 1, Word) then
		PWMPROCS
	elseif isuppercode(Word(1))
	or Word(1) <= `\s`
	or issubstring('lisp', 1, Word)
	or identprops(Word) == undef then
		false
	elseif isactive(Word) then
		POPACTIVE
	elseif (identprops(Word) ->> Props) == "macro" then
		POPMACS
	elseif isword(Props) and isstartstring('syntax', Props) then
		POPSYNTAX
	elseif identtype(Word) == "procedure" then
		if Props /== 0 then
			POPOPS
		elseif isstartstring('sys', Word) then
			POPSYS
		elseif isstartstring('ved_', Word) then
			VEDCOMMS
		elseif isstartstring('ved', Word) then
			VEDPROCS
		else
			POPPROCS
		endif
	else
		if isstartstring('pop', Word) then
			POPVARS
		elseif isstartstring('ved', Word)
		or     isstartstring('vved', Word) then
			VEDVARS
		else
			POPEXTRA
		endif
	endif
enddefine;


define lconstant Choosefiles(name, nonexact);
	lvars   name, nonexact, file
		;
	if nonexact then
		POPWHATFILES
	elseif name(1) == `<` and datalength(name) > 4 and isalphacode(name(2)) then
		#_< [^POPDATATYPES] >_#
	elseif syssearchpath(POPLIBDIRS, name sys_>< '.p') then
		#_< [^POPLIBS] >_#
	elseif syssearchpath(VEDLIBDIRS, name sys_>< '.p') then
		#_< [^VEDLIBS] >_#
	elseif Choosefile(consword(name)) ->> file then
		[^file]
	else
		[]
	endif
enddefine;


define lconstant Findinfo(word, file, verbose, left, right);
	lvars   i linesread  ;;; linesread is a really poor name for this variable
		word firstchar wordlen
		file dev charread
		verbose
		left right exact
		pos
		;
	unless (sysopen(sysfileok(POPWHATDIR dir_>< file), 0, "line") ->> dev) then
		vederror('Index file ' sys_>< file sys_>< ' not found - please report')
	endunless;

	word(1) -> firstchar;
	datalength(word) -> wordlen;
	not(left or right) -> exact;
	if left then false else 1 endif -> left;

	unless line_buf then inits(LBLEN) -> line_buf endunless;

	/* ignore all lines at top file, until a line beginning with '-' is
	 * read (so the data files can be used as HELP files)
	 */
	sysread(dev, line_buf, LBLEN) -> linesread;
	if linesread == 0 then
		vederror('Nothing in data file: ' sys_>< file)
	endif;

	if isstartstring('HELP', line_buf) then
		until (sysread(dev, line_buf, LBLEN) -> linesread, line_buf(1) == `-`)
		do
			if linesread == 0 then
				vederror('Wrong format in HELP file: ' sys_>< file)
			endif;
		enduntil;
	endif;

	sysread(dev, line_buf, LBLEN) -> linesread;
	while linesread fi_> 1 do
		if  (fast_subscrs(1, line_buf) ->> charread) fi_> `\s`
		and (issubstring_lim(word, 1, left, linesread fi_- 1, line_buf) ->> pos)
		and (right or pos fi_+ wordlen == linesread)
		then
			[%
				;;; drop a header for this list of data for later use
				if member(file, POPFORMATFILES) then
					true, substring(1, linesread fi_- 1, line_buf)
				else
					false
				endif;

				;;; loop while there are lines headed by whitespace
				;;; eof (linesread == 0) or a blank line (linesread == 1)
				;;; will terminate the loop
				while (sysread(dev, line_buf, LBLEN) ->> linesread) fi_> 1 do
					for i from 1 to linesread do  ;;; skip leading whitespace
					quitif(fast_subscrs(i, line_buf) fi_> `\s`);    ;;; printable?
					endfor;
				quitif(i == 1);                     ;;; no leading whitespace
					substring(i, linesread - i, line_buf);       ;;; extract text
				quitunless(verbose);      ;;; only one line of text requested
				endwhile;
			%];
			if exact then
	quitloop;
			endif;
			unless verbose then   ;;; if verbose then we have already read in
				sysread(dev, line_buf, LBLEN) -> linesread;     ;;; the next line
			endunless;
		else
			sysread(dev, line_buf, LBLEN) -> linesread;
	quitif(left and charread fi_> firstchar);
		endif;
	endwhile;

	sysclose(dev);
enddefine;


;;; --- Displaying the info ---------------------------------------------

lconstant short_form = newproperty(
   [[actions                'Acts']
	[array                  'Array']
	[boolean                'Bool']
	[byte_struc             'Bstruc']
	[character              'Char']
	[datastructure          'Dstruc']
	[device                 'Dev']
	[external_procedure     'ExtPdr']
	[field_specifier        'Spec']
	[filename               'File']
	[integer                'Int']
	[integral               'Int']
	[key                    'Key']
	[label                  'Lab']
	[number                 'Num']
	[pattern                'Pattern']
	[procedure              'Pdr']
	[process                'Process']
	[reference              'Ref']
	[sequence               'Seq']
	[string                 'Str']
	[structure              'Struc']
	[vector                 'Vec']
	[vectorclass            'Vclass']
	[ved_file_structure     'VedFile']
   ], 31, false, "perm");


define lconstant Shorteninfo(call) -> call;
	lvars   call,
		i   = 0,
		j,
		len = datalength(call),
		pos = 1,
		;

	define lconstant abbr(str) -> str;
		lvars other str ch;
		if islowercode(subscrs(1, str) ->> ch) then
			if short_form(consword(str)) ->> other then
				other -> str;
			else
				lowertoupper(ch) -> fast_subscrs(1, str);
			endif;
		endif
	enddefine;      /* abbr */

	define lconstant shorten(str);
		lvars   b,
			str,
			a   = 0,
			sep = false,
			;
		while (locchar(`|`, a fi_+ 1, str) ->> b) do
			if sep then sep else `|` -> sep endif;
			explode(abbr(substring(a fi_+ 1, b fi_- a fi_- 1, str)));
			b -> a;
		endwhile;
		if sep then sep endif;
		explode(abbr(substring(a fi_+ 1, if locchar(`:`, a fi_+ 1, str) ->> b then
											 b fi_- 1
										 else
											 datalength(str)
										 endif fi_- a, str)))
	enddefine;      /* shorten */

	define lconstant isargnamehere(i);
		lvars i;
		islowercode(i)   or isnumbercode(i)   or i == `"`
		/* is a datatype or a literal integer or quoted word */
	enddefine;

	cons_with consstring
	{%
		while (locchar(`<`, i fi_+ 1, call) ->> i) do
			explode(substring(pos, i fi_- pos, call));
			i -> pos;
			if  i /== len
			and isargnamehere(subscrs(i fi_+ 1, call))
			and (locchar(`>`, i fi_+ 2, call) ->> j) then
				j fi_+ 1 -> pos;
				shorten(substring(i fi_+ 1, j fi_- i fi_- 1, call));
			endif
		endwhile;
		explode(allbutfirst(pos fi_- 1, call));
	%} -> call;
enddefine;


;;; --- Displaying the info --------------------------------------------

lvars tmp_file = false;

define lconstant Ved_??_tmp_file();
	unless tmp_file then
		systmpfile(false, 'what', nullstring) -> tmp_file
	endunless;
	tmp_file
enddefine;


define lconstant Showinfo(infolist, verbose, nonexact);
	lvars   call info
		infolist verbose nonexact
		clearflag startline
		;
	dlocal  vedargument, vedstartwindow,
		vedindentstep = 4
		;
	if null(infolist) then
		vederror('No information available')
	elseif not(verbose) and null(tl(infolist)) then
		hd(infolist) -> info;
		Shorteninfo(info(if hd(info) then 3 else 2 endif)) -> call;
		if hd(info) and nonexact then
			info(2) sys_>< ': ' sys_>< call -> call
		endif;
		consstring(vedscreencommandmark, `\s`, 2) sys_>< call -> call;
		vedrestorescreen();
		vedsetstatus(call, false, true);
		vedsetcursor();
		chainfrom(vedprocesschar, vedprocesschar)
	else
		min(vedstartwindow, vedscreenlength >> 1) -> vedstartwindow;
		Ved_??_tmp_file() -> vedargument;
		ved_ved();
		false ->> vedbreak -> vedwriteable;
		vedendfile();

		for info in infolist do
		nextif(null(tl(info)));
			if verbose then
				vedinsertstring(dest(tl(info)) -> info);
				applist(info,   procedure;
									veddocr();
									vedcharinsert(`\t`);
									vedinsertstring()
								endprocedure);
			else
				if hd(info) then
					vedinsertstring(info(2));
					vedinsertstring(': ');
					vedinsertstring(info(3));
				else
					vedinsertstring(hd(tl(info)));
				endif;
			endif;
			veddocr();
		endfor;

		vedputmessage((length(infolist) ->>info) sys_>< if info == 1 then
															' reference'
														else
															' references'
														endif sys_>< ' found');
	endif
enddefine;


define ved_do_what(verbose);
	lvars   file left right
		verbose
		string name wordlist infolines
		;
	dlocal  vedautowrite = false,
		;

	define lconstant parse_vedargument(string) -> left -> right -> string;
		lvars   string left right len
			;
		unless isstring(string) then       ;;; is integer!!!
			vederror('Can only get info for words!');
		endunless;
		datalength(string) -> len;
		string(1) == `*` -> left;
		string(len) == `*` -> right;
		if left and right then
			len > 2 ->> left -> right
		endif;
		if left or right then
			if right then len - 1 -> len endif;
			substring(if left then 2, len - 1 else 1, len endif, string)
				-> string
		endif;
	enddefine;      /* parse_vedargument */

	if vedargument = nullstring then
		vednextitem() sys_>< nullstring -> vedargument;
#_IF hd(sys_os_type) == "unix"
		;;; if it is all uppercase (e.g. in HELP files ) change to lower case
		;;; No difference in VMS

		define lconstant Haslowercode() with_nargs 1;
			appdata(procedure() with_nargs 1;
						if islowercode() then
							exitfrom(true, Haslowercode)
						endif
					endprocedure)
		enddefine;

		unless Haslowercode(vedargument) then
			uppertolower(vedargument) -> vedargument
		endunless;
#_ENDIF
		vedcommand sys_>< vedspacestring sys_>< vedargument -> string;
		;;; put enlarged command on status line, before current command
		vedswitchstatus();
		unless vedline > 1 and string = vedbuffer(vedline - 1) then
		;;; put a copy of translated command in command line buffer
			vedlineabove();
			string -> vedthisline();
			vednextline();
		endunless;
		vedswitchstatus();
	endif;
	sysparse_string(vedargument) -> wordlist;
	[%
		for name in wordlist do
			parse_vedargument(name) -> left -> right -> string;
			for file in Choosefiles(string, left or right) do
				Findinfo(string, file, verbose, left, right)
			endfor
		endfor
	%] -> infolines;

	if verbose.isinteger then
		if infolines == [] then return(false) else true endif;
		if verbose == 0 then false -> verbose endif;
	endif;
	Showinfo(infolines, verbose, left or right)
enddefine;


global vars procedure (
	ved_what    =   ved_do_what(% false %),
	ved_whats   =   ved_do_what(% true %),
	);


.
12c
;;; --- Finding the info ----------------------------------------------
.
4,6c
 > Author:          John Williams, Jan  3 1990
 > Documentation:   HELP * VED_WHAT
 > Related Files:   C.all/lib/ved/ved_whats.p
					C.all/lib/data/ved_what/...
.
