/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 > File:            C.alpha/src/pdr_compose.p
 > Purpose:         Composing procedures (Alpha version)
 > Author:          John Gibson, Aug 25 1994
 > Documentation:	REF * PROCEDURE
 > Related Files:   C.alpha/src/ass.p
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'drop_code.ph'

;;; -------------------------------------------------------------------

section $-Sys$-Vm;

	/*	Construct a raw procedure for composition of two procedures
		-- used by <>
	*/
define $-Sys$-Cons_pcomposite() -> _comp;
	lvars _comp, _drop_ptr, _offs, _size;

	;;; macro for dropping instructions
	lconstant macro _CODE = [_drop_ptr!(code)++ -> _drop_ptr];

	;;; 13 instructions
	@@PD_COMPOSITE_TABLE _add @@(w)[_13 | code.r] _sub @@POPBASE -> _size;
	Get_store(_size) -> _comp;

	;;; initialise some of header
	##(w){_size} -> _comp!PD_LENGTH;
	_0		->> _comp!PD_REGMASK
			->> _comp!PD_NLOCALS
			->> _comp!PD_NUM_STK_VARS
			->> _comp!PD_NUM_PSTK_VARS
			->  _comp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _comp!PD_GC_OFFSET_LEN;
	lconstant _flen = ##SF_LOCALS _sub ##SF_RETURN_ADDR;	;;; = 2
	_flen -> _comp!PD_FRAME_LEN;

	;;; start of instructions
	_comp@PD_COMPOSITE_TABLE ->> _drop_ptr -> _comp!PD_EXECUTE;

	;;; stack frame (3 instrs)
	_MEMf_INST(_OP_lda, _:RGsp, @@(w)-[_flen], _:RGsp)		-> _CODE;
	_MEMf_INST(_OP_stW, _:RGret, @@SF_RETURN_ADDR[_flen], _:RGsp)
															-> _CODE;
	_MEMf_INST(_OP_stW, _:RGpb, @@SF_OWNER, _:RGsp)			-> _CODE;

	;;; plant code to call first then second (6 instrs)
	@@PD_COMPOSITE_P1 -> _offs;
	repeat 2 times
		_MEMf_INST(_OP_ldW, _:RGpb, _offs, _:RGpb)			-> _CODE;
		_MEMf_INST(_OP_ldW, _:RGt0, @@PD_EXECUTE, _:RGpb)	-> _CODE;
		_MEMf_JMP_INST(_HINT_jsr, _:RGret, _:RGt0)			-> _CODE;
		@@(w){_offs}++ -> _offs
	endrepeat;

	;;; exit code (4 instrs)
	_drop_ptr -> _comp!PD_EXIT;			;;; pointer to exit code
	_MEMf_INST(_OP_ldW, _:RGret, @@SF_RETURN_ADDR[_flen], _:RGsp)
															-> _CODE;
	_MEMf_INST(_OP_lda, _:RGsp, @@(w)[_flen], _:RGsp)		-> _CODE;
	_MEMf_INST(_OP_ldW, _:RGpb, @@SF_OWNER, _:RGsp)			-> _CODE;
	_MEMf_JMP_INST(_HINT_ret, _:RGzero, _:RGret)			-> _CODE;
enddefine;

endsection;		/* $-Sys$-Vm */
