/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 * File:	C.hppa/src/amain.s
 * Purpose:	Main assembler routines for HP PA-RISC 1.1
 * Author:	Julian Clinton, December 1992 (see revisions)
 */


#_<

#_INCLUDE 'declare.ph'

section $-Sys;

vars
	_init_args,
	;

endsection;

>_#


#_INCLUDE 'asm_macros.h'

/************************* wrapping structures ************************/

	.code
	.word	Lcode_end-Lcode_start, C_LAB(Sys$-objmod_pad_key)
Lcode_start
	.data
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start

/**********************************************************************/

	.code

;;; _MAIN:
;;;	Entry point to POPLOG; called from _START in /lib/crt0.

;;; Call:
;;;	main(argc, argv, envp)

DEF_C_LAB (Sys$- _entry_point)

	.export		main, entry
main
	.proc
	.callinfo	calls, save_rp, entry_gr=18
	.enter

	;;; Clear __pop_in_user_extern
	STV32		0, EXTERN_NAME(__pop_in_user_extern)

	;;; Save pointer to argument vector (argv) which is passed in %arg1
	STV32		%arg1, I_LAB(Sys$- _init_args)

	;;; Initialise stack pointer
	LDV32		I_LAB(Sys$-Extern$- _saved_usp), %usp

	;;; Set registers
	bl		reset_pop_reg_environ, %r31
	nop

	;;; Start the system
	CALLSYS		XC_LAB(setpop)
	nop

	;;; Exit with 0
	bl		EXTERN_NAME(_exit), %rp
	copy		0, %arg0

	.leave
	.procend

	.code
	.import		C_LAB(Sys$-objmod_pad_key), data
	.import		XC_LAB(setpop), data
	.import		I_LAB(Sys$- _init_args), data
	.import		I_LAB(Sys$-Extern$- _saved_usp), data
	.import		reset_pop_reg_environ, code
	.import		EXTERN_NAME(_exit), code
	.import		EXTERN_NAME(__pop_in_user_extern), data


/***************** end labels for wrapping structures *****************/

	.code
	.align  8
Lcode_end
	.data
	.align  8
Ldata_end

/**********************************************************************/

/* --- Revision History ---------------------------------------------------
--- Julian Clinton, Dec 17 1993
		Modified initialisation of usp and removed vars
		declaration of _system_stack_base and _SAVED_USP macro.
--- Integral Solutions Ltd (Julian Clinton), Nov 16 1993
		Moved code other than main to amisc.s.
 */
