/* --- Copyright University of Sussex 1992. All rights reserved. ----------
 * File:		C.hppa/src/asm_macros.h
 * Purpose:		Assembler include file for HP-PA
 * Author:		Simon Nichols, Rob Duncan, Julian Clinton, Nov. 1992
 */


;;; -- Register names -----------------------------------------------------

%chain	.reg			%r1		;;; ADDIL/CHAIN_REG
%npop4	.reg			%r3		;;; Non-pop register 4
%npop3	.reg			%r4		;;; Non-pop register 3
%npop2	.reg			%r5		;;; Non-pop register 2
%npop1	.reg			%r6		;;; Non-pop register 1
%npop0	.reg			%r7		;;; Non-pop register 0
%pop5	.reg			%r8		;;; Pop register 5
%pop4	.reg			%r9		;;; Pop register 4
%pop3	.reg			%r10	;;; Pop register 3
%pop2	.reg			%r11	;;; Pop register 2
%pop1	.reg			%r12	;;; Pop register 1
%pop0	.reg			%r13	;;; Pop register 0
%pzero	.reg			%r14	;;; Value of popint 0 (0<<2||3 = 3)
%false	.reg			%r15	;;; Address of <false>
%svb	.reg			%r16	;;; Address of special variable block
%pb		.reg			%r17	;;; Procedure base
%usp	.reg			%r18	;;; User stack pointer


;;; -- Macro definitions --------------------------------------------------

		;;; load a 32 bit symbol to a register
		;;;
LDA32	.macro			sym, reg
		ldil			L%sym, reg
		ldo				R%sym(reg), reg
		.endm

		;;; load the value of a 32 bit symbol to a register
		;;;
LDV32	.macro sym, reg
		ldil			L%sym, reg
		ldw				R%sym(reg), reg
		.endm

		;;; store a register value to a 32 bit address:
		;;; uses %r1 (aka %chain) as a scratch register.
		;;;
STV32	.macro reg, sym
		ldil			L%sym, %r1
		stw				reg, R%sym(%r1)
		.endm

		;;; call a procedure from a register:
		;;; uses %r1 (aka %chain) and %r2 (aka %rp) as scratch registers.
		;;; N.B. this has a delay slot
		;;;
CALL	.macro reg
		ldw				_PD_EXECUTE(reg), %r1
		ldsid			(reg), %r2
		mtsp			%r2, %sr0
		ble				(%sr0, %r1)
		.endm

		;;; call a named system procedure
		;;; uses %r1 (aka %chain) and %r2 (aka %rp) as scratch registers
		;;; N.B. this has a delay slot
		;;;
CALLSYS .macro sym
		ldil			L%sym, %r1
		ldsid			(%r1), %r2
		mtsp			%r2, %sr0
		ble				R%sym(%sr0, %r1)
		.endm

		;;; chain a procedure from a register:
		;;; uses %r1 (aka %chain) and %r2 (aka %rp) as scratch registers.
		;;; N.B. this has a delay slot
		;;;
CHAIN	.macro reg
		ldw				_PD_EXECUTE(reg), %r1
		ldsid			(reg), %r2
		mtsp			%r2, %sr0
		be				(%sr0, %r1)
		.endm

		;;; chain a named system procedure
		;;; uses %r1 (aka %chain) and %r2 (aka %rp) as scratch registers
		;;; N.B. this has a delay slot
		;;;
CHAINSYS .macro sym
		ldil			L%sym, %r1
		ldsid			(%r1), %r2
		mtsp			%r2, %sr0
		be				R%sym(%sr0, %r1)
		.endm

		;;; local return
		;;; N.B. this has a delay slot
		;;;
RET		.macro
		bv				(%r31)
		.endm

		;;; external return
		;;; uses %r1 (aka %chain) as a scratch register
		;;; N.B. this has a delay slot
		;;;
RETE	.macro
		ldsid			(%r31), %r1
		mtsp			%r1, %sr0
		be				(%sr0, %r31)
		.endm
