/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 * File:            C.power/src/alisp.s
 * Purpose:
 * Author:          John Gibson, Mar  2 1998
 */

;;; ---------------------- LISP ROUTINES ---------------------------------

;;;	***********************************************
;;;	****         NOTE ASSEMBLER BUG:          *****
;;;	****  (___reg) DOES NOT ASSEMBLE AS 0(___reg)   *****
;;;	***********************************************

#_<

#_INCLUDE 'asm.ph'

constant	_setstklen_diff
	;

>_#


ASM_START_FILE


ASM_CODE_PSECT


	;;; _setstklen(____________saved_stklen, ________nresults)

ASM_ALIGN_QUAD
DEF_C_LAB (_setstklen)
	ldW	rt0, _SVB_OFFS(_userhi)(rsvb)	;;; stack base
	ldW	rt1, 0(rusp)		;;; ________nresults (popint)
	ldW	rt2, _WOFFS(rusp)	;;; ____________saved_stklen (popint)
	la	rusp, _WOFFS*2(rusp)
	add	rt1, rt1, rt2		;;; ________nresults + ____________saved_stklen
	addi	rt1, rt1, -6		;;; -6 (popint bits) = desired stacklen
	subfc	rt0, rt1, rt0		;;; _userhi - that = desired usp
	cmplW	CR0, rt0, rusp		;;; same as current usp?
	beqlr				;;; return if so
	;;; else drop thru to _setstklen_diff


	;;; _setstklen_diff()
	;;; required usp in rt0, CR0 set for comparison between rt0 and rusp

ASM_ALIGN_QUAD
DEF_C_LAB (_setstklen_diff)
	blt	La1			;;; br if stack not long enough
	mr	rusp, rt0		;;; else set us to desired len
	blr

	;;; extend stack by pushing [] sufficient times
La1:	ldW	rt1, _SVB_OFFS(nil)(rsvb)
La2:	stWu	rt1, -_WOFFS(rusp)		;;; push []
	cmplW	CR0, rt0, rusp
	bne	La2
	blr


ASM_END_FILE
