/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 > File:            C.power/src/pdr_compose.p
 > Purpose:         Composing procedures (POWER(PC) version)
 > Author:          John Gibson, Apr 17 1998
 > Documentation:	REF * PROCEDURE
 > Related Files:   C.power/src/ass.p
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'drop_code.ph'

;;; -------------------------------------------------------------------

section $-Sys$-Vm;

	/*	Construct a raw procedure for composition of two procedures
		-- used by <>
	*/
define $-Sys$-Cons_pcomposite() -> _comp;
	lvars _comp, _drop_ptr, _offs, _size;

	;;; macro for dropping instructions
	lconstant macro _CODE = [_drop_ptr!(code)++ -> _drop_ptr];

	;;; 15 instructions
	@@PD_COMPOSITE_TABLE _add @@(w)[_15 | code.r] _sub @@POPBASE -> _size;
	Get_store(_size) -> _comp;

	;;; initialise some of header
	##(w){_size} -> _comp!PD_LENGTH;
	_0		->> _comp!PD_REGMASK
			->> _comp!PD_NLOCALS
			->> _comp!PD_NUM_STK_VARS
			->> _comp!PD_NUM_PSTK_VARS
			->  _comp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _comp!PD_GC_OFFSET_LEN;
	lconstant _flen = ##SF_LOCALS _sub ##SF_RETURN_ADDR;	;;; = 2
	_flen -> _comp!PD_FRAME_LEN;

	;;; start of instructions
	_comp@PD_COMPOSITE_TABLE ->> _drop_ptr -> _comp!PD_EXECUTE;

	;;; stack frame (3 instrs)
	_XFX_inst(_OP_mfspr, _SPR_LR, _:RGt1)						-> _CODE;
	_D_inst(_OP_stWu, _:RGpb, @@(w)-[_flen], _:RGsp)			-> _CODE;
	_D_inst(_OP_stW, _:RGt1, @@SF_RETURN_ADDR[_flen], _:RGsp)	-> _CODE;

	;;; plant code to call first then second (8 instrs)
	@@PD_COMPOSITE_P1 -> _offs;
	repeat 2 times
		_D_inst(_OP_ldW, _:RGpb, _offs, _:RGpb)					-> _CODE;
		_D_inst(_OP_ldW, _:RGt0, @@PD_EXECUTE, _:RGpb)			-> _CODE;
		_XFX_inst(_OP_mtspr, _SPR_CTR, _:RGt0)					-> _CODE;
		_X_inst(_OP_bcctrl, _BO_ALWAYS, _0, _0)					-> _CODE;
		@@(w){_offs}++ -> _offs
	endrepeat;

	;;; exit code (4 instrs)
	_drop_ptr -> _comp!PD_EXIT;			;;; pointer to exit code
	_D_inst(_OP_ldW, _:RGt1, @@SF_RETURN_ADDR[_flen], _:RGsp)	-> _CODE;
	_D_inst(_OP_ldWu, _:RGpb, @@(w)[_flen], _:RGsp)				-> _CODE;
	_XFX_inst(_OP_mtspr, _SPR_LR, _:RGt1)						-> _CODE;
	_X_inst(_OP_bclr, _BO_ALWAYS, _0, _0)						-> _CODE;
enddefine;

endsection;		/* $-Sys$-Vm */
