/* --- Copyright University of Sussex 1994.  All rights reserved. ---------
 > File:           C.pwm/lib/flavours/icon_flavour.p
 > Purpose:        flavour for a sun window icon
 > Author:         Mark Rubinstein, Jul  8 1986 (see revisions)
 > Documentation:  HELP * WINDOW_FLAVOURS /icon_flavour
 > Related Files:  LIB * WINDOW_FLAVOURS
 */

section;

;;; -- ICON ----------------------------------------------------------------
flavour icon isa named_object;
ivars mywindow name = '';
	defmethod selectself;
		mywindow <- selectself;
	enddefmethod;
	defmethod after updaterof name;
		if mywindow<-window_id then
			^selectself;
			name sys_>< '' -> pwm_iconlabel(pwm_selected);
		endif;
	enddefmethod;
	defmethod position;
		if mywindow<-window_id then
			^selectself;
			pwm_iconlocation(pwm_selected);
		else
			false
		endif;
	enddefmethod;
	defmethod updaterof position(p);
	lvars p;
		if mywindow<-window_id then
			^selectself;
			p -> pwm_iconlocation(pwm_selected);
		else
			false
		endif
	enddefmethod;
/* not yet implemented by PWM
	defmethod file;
		^selectself;
		pwm_icon_file();
	enddefmethod;
	defmethod updaterof file(f);
	lvars f;
		if mywindow<-window_id then
			^selectself;
			f -> pwm_icon_file();
		endif;
	enddefmethod;
*/
endflavour;

endsection;

/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr 21 1994
		Moved to C.pwm
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwm_icon_label          -> pwm_iconlabel
		pwm_icon_location       -> pwm_iconlocation
--- Poplog System, Sep 18 1987 (Ian Rogers)
	removed vars icon_flavour as it corrupts flavour record
--- Nic Ford, Aug 20 1987 - made -icon_flavour- a var for -uses-
--- Ian Rogers - Nic Ford, Jul 20-21 1987
	Changed old style (V12) PWM procedures to new style (V13) equivalents.
 */
