/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/conspwmitem.p
 > Purpose:		Stuff needed for PWM items
 > Author:		Ben Rubinstein, Mar 15 1987 (see revisions)
 > Documentation:  HELP PWMITEMS
 */
compile_mode :pop11 +strict;

uses pwm_itemhandler;
uses pwmrasterop;

section $-library$-pwmlib => conspwmitem pwm_kill_item
								pwm_itemvalue pwm_itemarea;


;;; format of items to be used with this library:
defclass pwmitem {
		pi_name,	;;; presumably a string: free format
		pi_window, 	;;; a PWM window ID, as submitted to -pwm_itemhandler-
		pi_value,	;;; free format
		pi_event,	;;;	\
		pi_button,	;;;  }- as submitted to -pwm_itemhandler-
		pi_area,	;;; /
		pi_catch,	;;;	procedure submitted to -pwm_itemhandler- (SEE BELOW)
		pi_proc		;;; free format: presumbly the user proc. to be called
					;;;    when value is changed.
};


;;; NOTE format of catcher procedure: takes one formal argument (presumably
;;; any other args necessry have been frozen in): generally this will be the
;;; mouse event vector supplied by -pwm_itemhandler-.  It may also be called
;;; by -pwm_itemvalue-, however, and in this case the argument will be:
;;;
;;;		true: 	please return current value of item on stack
;;; 	false:	take a new value for the item  off the stack, and do
;;; 				whatever's necessary.



;;; export a non-updating version of the area accessor
define pwm_itemarea(item);
	lvars item;
	item.pi_area;
enddefine;

procedure(i);
	lvars i;
	sys_syspr('<pwmitem ');
	if i.pi_name then
		sys_syspr(i.pi_name);
	elseif i.pi_proc then
		sys_syspr(i.pi_proc);
	endif;
	cucharout(`>`);
endprocedure -> class_print(pwmitem_key);

;;; utility used by several items: draw a box, clearing any garbage under it
;;; (note that this doesn't dlocal ras-op)
define empty_box(x, y, w, h);
	lvars x, y, w, h;
	PWM_SET -> pwmrasterop;
	pwm_wipe_area(x, y, w, h);
	PWM_CLR -> pwmrasterop;
	pwm_wipe_area(x fi_+ 1, y fi_+ 1, w fi_- 2, h fi_- 2);
enddefine;

define pwm_kill_item(item);
	lvars item box;
	dlocal pwmgfxsurface, pwmrasterop;

	unless item.pi_window then
		mishap(item, 1, 'ITEM HAS ALREADY BEEN REMOVED');
	endunless;

	;;; remove event trap
	false -> pwm_itemhandler(item.pi_window, item.pi_event,
							item.pi_button, (item.pi_area ->> box));
	;;; clear that area of the window
	item.pi_window -> pwmgfxsurface;
	PWM_CLR -> pwmrasterop;
	pwm_wipe_area(subscrv(1, box), subscrv(2, box),
						subscrv(3, box) - subscrv(1, box) + 1,
						subscrv(4, box) - subscrv(2, box) + 1);

	;;; now mark it as cancelled.
	false ->> item.pi_window ->> item.pi_value ->> item.pi_event
		->> item.pi_button ->> item.pi_area ->> item.pi_proc -> item.pi_catch;
enddefine;

define pwm_itemvalue(item);
	lvars item;
	if item.pi_window then
		(item.pi_catch)(true);
	else
		mishap(item, 1, 'ITEM HAS BEEN REMOVED');
	endif;
enddefine;

define updaterof pwm_itemvalue(v, item);
	lvars v item;
	if item.pi_window then
		(item.pi_catch)(v, false);
	else
		mishap(item, 1, 'ITEM HAS BEEN REMOVED');
	endif;
enddefine;

endsection;


/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwm_gfxwipearea         -> pwm_wipe_area
		pwmgfxrasterop          -> pwmrasterop
		pwmitemhandler          -> pwm_itemhandler
		pwmitem_area            -> pwm_itemarea
		pwmitem_valof           -> pwm_itemvalue
		remove_pwmitem          -> pwm_kill_item
--- Ben Rubinstein, Mar 25 1987 - added window to item record
*/
