/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 > File:            C.pwm/lib/pwm/pwm_colourmapentry.p
 > Purpose:         Read/set the actual values of a logical colour
 > Author:          Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:   HELP *PWMCOLOURS
 > Related Files:
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_colourmapentry;

uses pwmsequences;

define pwm_colourmapentry(entry);
	lvars entry;
	checkinteger(entry, 0, false);
	if getpwmreport(entry, Pwms_gfxgetmapentry, Pwms_gfxrepmapentry) == 3 do
		consvector(3);
	else
		false
	endif;
enddefine;

define updaterof pwm_colourmapentry(b, entry);
	lvars entry r g b;
	if b.isvector then
		fast_subscrv(1, b) -> r;
		fast_subscrv(2, b) -> g;
		fast_subscrv(3, b) -> b;
	else
			-> g, -> r;
	endif;
	checkinteger(entry, 0, false);
	checkinteger(r, 0, 255);
	checkinteger(g, 0, 255);
	checkinteger(b, 0, 255);
	pwmsendmessage(b, g, r, entry, Pwms_gfxsetmapentry, pwmflushmessage);
enddefine;

endsection;


/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Aug 25 1989
		These procedures were originally called -pwm_gfxgetmapentry- and
		-pwm_gfxsetmapentry-  The argument order of the updater had to be
		changed.
 */
