/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_copy_raster.p
 > Purpose:		Copy or move a bit image from one place to another
 > Author:      Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_copy_raster;

uses pwmsequences;
uses pwmrasterop;	;;; to get -checkpwmrop-

define pwm_copy_raster(swin, sx, sy, wid, hght, op, dwin, dx, dy);
	lvars swin, sx, sy, wid, hght, dwin, dx, dy, op;
	checkpwmsurfid(swin) -> swin;
	checkpwmsurfid(dwin) -> dwin;
	checkpwmrop(op);
	checkinteger(sx, 0, false);
	checkinteger(sy, 0, false);
	checkinteger(wid, 0, false);
	checkinteger(hght, 0, false);
	checkinteger(dx, 0, false);
	checkinteger(dy, 0, false);
	pwmsendmessage(dy, dx, hght, wid, sy, sx,
								swin, op, dwin,
								Pwms_gfxcopyraster, pwmflushmessage);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwm_gfxcopyraster       -> pwm_copy_raster
		pwmgfxrasterop          -> pwmrasterop
 */
