/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_display_menu.p
 > Purpose:		Display a menu on screen and get the user's choice
 > Author:      Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMMENUS
 > Related Files:	LIB *PWM_DEFINEMENU
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_display_menu pwmselectedmenu;

uses pwmsequences;

global vars pwmselectedmenu;

;;; pwm_display_menu(<menu>)
;;; pwm_display_menu(<menu>, <window>, <int>, <int>)

define pwm_display_menu(mid) -> opt;
	lvars mid win x y opt message;
	if mid.isinteger then
		mid -> y -> x -> win -> mid;
		checkpwmwinid(win) -> win;
		checkinteger(x, 0, false);
		checkinteger(y, 0, false);
	else
		-1 -> win;
		0 ->> x -> y;
	endif;
	if mid.isstring then
		false -> pwmselectedmenu;
		mid, y, x, win, Pwms_dispnewmenu,
	else
		checkpwmmenuid(mid ->> pwmselectedmenu) -> mid;
		y, x, win, mid, Pwms_displaymenu,
	endif;
	unless getpwmreport(Pwms_menuresult) == 1 do false endunless -> opt;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - renamed from pwm_displaymenu
 */
