/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:           C.pwm/lib/pwm/pwm_draw_arc.p
 > Purpose:        Draw an elliptical arc on a PWM surface
 > Author:         Ben Rubinstein, Mar  3 1987 (see revisions)
 > Documentation:	HELP * PWMGRAPHICS
 */
compile_mode :pop11 +strict;

uses poppwmlib;

section $-library$-pwmlib => pwm_draw_arc;

;;; draw an (elliptical) arc of radii rx, ry with centre at cx,cy,
;;; clockwise from angle a1 to angle a2 (in degrees, with 0 at north).
;;;
define pwm_draw_arc(cx, cy, rx, ry, a1, a2);
	lvars cx cy rx ry a1 a2 a lx ly x y;
	lconstant astep = 7;
	dlocal popradians = false, pwmalwaysflush = false;

	checkinteger(cx, false, false);
	checkinteger(cy, false, false);
	checkinteger(a1, false, false);
	checkinteger(a2, false, false);
	if a2 < a1 then a2 + 360 -> a2 endif;

	cx fi_+ round(rx * sin(a1)) -> lx;
	cy fi_- round(ry * cos(a1)) -> ly;
	a1 fi_+ astep -> a;

	while a fi_< a2 do		;;; don't do last point even if exact
		cx fi_+ round(rx * sin(a)) -> x;
		cy fi_- round(ry * cos(a)) -> y;
		pwm_draw_line(lx, ly, x, y, 2);
		x -> lx; y -> ly;
		a fi_+ astep -> a;
	endwhile;

	cx fi_+ round(rx * sin(a)) -> x;
	cy fi_- round(ry * cos(a)) -> y;
	pwm_draw_line(lx, ly, x, y, 2);		;;; now do last segment
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwm_gfxdrawarc          -> pwm_draw_arc
		pwm_gfxdrawline         -> pwm_draw_line
 */
