/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_draw_ellipse.p
 > Purpose:		Draw an outline or filled circle or ellipse
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

uses poppwmlib;

section $-library$-pwmlib => pwm_draw_ellipse;

define pwm_draw_ellipse(solid, ry);
	lvars cx cy rx ry solid theta th_step dx dy;
	lvars left right top bottom o_left, o_right, o_top, o_bottom;
	dlocal popradians = false, pwmalwaysflush = false;

	if solid.isboolean then solid, ry else solid endif -> rx -> solid;
	if solid.isboolean then
		solid, 90 / max(rx, ry)
	else
		solid
	endif -> th_step -> solid -> cy -> cx;
	checkinteger(rx, 1, false);
	checkinteger(ry, 1, false);
	checkinteger(cx, 0, false);
	checkinteger(cy, 0, false);
	for theta from 0 by th_step to 89 do
		round(sin(theta) * rx) -> dx;
		round(cos(theta) * ry) -> dy;
		cx fi_- dx -> left;
		cx fi_+ dx -> right;
		cy fi_- dy -> top;
		cy fi_+ dy -> bottom;

		if theta == 0 do
			left -> o_left; right -> o_right;
			top -> o_top; bottom -> o_bottom;
		elseunless left == o_left or top == o_top do
			if solid then
				pwm_wipe_area(left, o_top, right - left + 1, top - o_top);
				pwm_wipe_area(left, bottom, right - left + 1, o_bottom - bottom);
			else
				pwm_draw_line(right, bottom, o_right, o_bottom, 2);
				pwm_draw_line(left, bottom, o_left, o_bottom, 2);
				pwm_draw_line(right, top, o_right, o_top, 2);
				pwm_draw_line(left, top, o_left, o_top, 2);
			endif;
			left -> o_left; right -> o_right;
			top -> o_top; bottom -> o_bottom;
		endif;
	endfor;
	if solid then
		pwm_wipe_area(left, o_top, right - left + 1, o_bottom - o_top);
	else
		pwm_draw_line(o_left, o_bottom, cx - rx, cy, o_left, o_top, 3);
		pwm_draw_line(o_right, o_bottom, cx + rx, cy, o_right, o_top, 3);
	endif;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwm_gfxdrawellipse      -> pwm_draw_ellipse
		pwm_gfxdrawline         -> pwm_draw_line
		pwm_gfxwipearea         -> pwm_wipe_area
--- Ben Rubinstein, Mar  3 1987 - added dlocal popradians
*/
