/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_draw_line.p
 > Purpose:		Draw one or more lnked lines
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib  => pwm_draw_line;

uses pwmsequences;

define pwm_draw_line(coords);
	lvars coords tcoords, x = false, y = false;
	if coords.islist then
		(coords.length) -> tcoords;
		if coords.hd.isinteger then
			tcoords / 2 -> tcoords;
		endif;
		unless tcoords.isinteger do
			mishap(coords, 1, 'odd number of coordinates');
		endunless;
		dl(coords);
	else
		coords -> tcoords;
	endif;
	until tcoords == 0 do
		tcoords - (min(tcoords, 20) ->> coords) -> tcoords;
			pwmsendmessage(Pwms_gfxlinestart, false);
			if x and y then pwmsendmessage(y, x, Pwms_gfxlinepoint, false) endif;
			repeat coords - 1 times
				-> y;
				unless y.isinteger do y(1), y(2) -> y; endunless -> x;
				pwmsendmessage(y, x, Pwms_gfxlinepoint, false);
			endrepeat;
			-> y;
			unless y.isinteger do y(1), y(2) -> y; endunless -> x;
			pwmsendmessage(y, x, Pwms_gfxlineend, pwmflushmessage);
	enduntil
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Aug  7 1989  - Renamed from -pwm_gfxdrawline-
--- Ben Rubinstein, Mar  4 1987 - fixed for list-of-structures case
*/
