/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_draw_text.p
 > Purpose:     Print a string in the current graphics font
 > Author:      Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:   HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib  => pwm_draw_text;

uses pwmsequences;

define pwm_draw_text(x, y, t);
	lvars x y t;
	unless t.isstring or t.isword do
		mishap(t, 1, 'STRING OR WORD NEEDED')
	else
		checkinteger(x, false, false);
		checkinteger(y, false, false);
		pwmsendmessage(t, y, x, Pwms_gfxwritetext, pwmflushmessage);
	endunless
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - renamed from pwm_gfxtext
--- Poplog Documentation Officer, Sep  7 1987 (Ian Rogers)
	made second arguments of checkinteger-s false so that text may fall
	off the left and top of window.
--- John Williams, Jun 26 1987 - made 'pwm_gfxtext' global
 */
