/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_dump_raster.p
 > Purpose:     Dump a pwmrasterarray (a bit-image) to the PWM
 > Author:      Ben Rubinstein, Mar 10 1987 (see revisions)
 > Documentation:   HELP *PWMRASTERS
 */
compile_mode :pop11 +strict;

include sysdefs.ph;					;;; to see if this is a BSD system
uses pwm_make_rasterarray;			;;; to get -pwm_rasterdepth-
uses pwmsequences;

section $-library$-pwmlib => pwm_dump_raster;

#_IF DEF BERKELEY        		;;; ioctl stuff only works on BSD

include unix_ioctl.ph;

defclass lconstant sgttyb {
	dummy:full,       /* dummy first field */
	sg_ispeed:8,      /* input speed */
	sg_ospeed:8,      /* output speed */
	sg_erase:8,       /* erase character */
	sg_kill:8,        /* kill character */
	sg_flags:16,      /* mode flags */
};

define setrawmode(device, raw);
	lvars device, raw;
	lvars sg;
	conssgttyb(0, 0, 0, 0, 0, 0) ->  sg;
	if      sys_io_control(device, TIOCGETP, sg)
	then    (if raw then RAW else 0 endif)
							|| (sg.sg_flags &&~~ RAW) -> sg.sg_flags;
			unless  sys_io_control(device, TIOCSETP, sg)
			do      mishap(device, 1, 'unable to set device parameters');
			endunless
	else
			mishap(device, 1, 'unable to get device parameters');
	endif
enddefine;

#_ELSE

define setrawmode(device, raw);
	lvars device, raw;
	;;; do nothing
enddefine;

#_ENDIF

;;; return width (number of bits)  of current comms link
;;;
define pwm_com_width() -> bits;
	lvars bits c1 c2;
	lconstant oldwidth = conspair(false, false);
	;;; save it so we don't have to communicate on every dump, read etc;
	;;; save -poppid- in case we get stored in a saved image, and restored
	;;; over a remote/local link.
	if oldwidth.front == poppid then
		oldwidth.back -> bits;
	else
		setrawmode(poprawdevout, true);
		if getpwmreport(Pwms_getcomswidth, Pwms_repcomswidth) == 3 then
			-> bits -> c2 -> c1;
			bits -> oldwidth.back;
			poppid -> oldwidth.front;
			c1 ||/& c2 -> c1;       ;;; xor to get successful bits
			0 -> c2;
			;;; now count from left how many bits got through
			while (c1 && 1) == 1 do
				c2 + 1 -> c2;
				c1 >> 1 -> c1;
			endwhile;
			;;; and tell the PWM
			pwmsendmessage(c2, Pwms_setcomswidth, true);
			setrawmode(poprawdevout, false);
		else
			setrawmode(poprawdevout, false);
			mishap(0, 'unable to establish width of coms link');
		endif;
	endif
enddefine;

define pwm_dump_raster(x, y, array);
	lvars x y array x1 x2 y1 y2 width height depth avec;
	lvars bpr_a bpr_s index datastring si i byte by_row comwidth;

	;;; this also checks it's a suitably formatted 2-d array
	pwm_rasterdepth(array) -> depth;
	array.boundslist.destlist ->; -> y2 -> y1 -> x2 -> x1;
	x2 - x1 + 1 -> width;
	y2 - y1 + 1 -> height;

	;;; bytes-per-row in the array
	if ((width * depth) // 8 -> bpr_a) > 0 then bpr_a + 1 -> bpr_a endif;

	;;; find out how many bits we can send at a time
	if (isarray_by_row(array) ->> by_row)
	and (pwm_com_width() ->> comwidth) == 8 then
		/* full 8-bit connection */
		bpr_a -> bpr_s;
		array.arrayvector -> avec;  ;;; get at the underlying arrayvec

		pwmsendmessage(y, x, height, width,
						bpr_s,  ;;; bytes-per-row sent
						depth,  ;;; bits per pixel
						8,      ;;; bit per byte
						Pwms_gfxdumpraster, true);

		setrawmode(poprawdevout, true);

		1 -> index;
		repeat height times
			syswrite(poprawdevout, index, avec, bpr_a);
			index + bpr_a -> index;
		endrepeat;

	elseif not(by_row) or (depth <= comwidth and depth >= 4) then
		/* use less than eight-bit connection, and send one pixel per byte */
		width -> bpr_s;
		inits(bpr_s) -> datastring;
		pwmsendmessage(y, x, height, width,
						bpr_s,  ;;; bytes-per-row sent
						depth, ;;; bits per pixel
						depth, ;;; bits per byte
						Pwms_gfxdumpraster, true);

		setrawmode(poprawdevout, true);
		for y from y1 to y2 do
			0 -> index;
			for x from x1 to x2 do
				array(x, y) || 2:01000000   ;;; so it isn't a control char
						-> fast_subscrs(index fi_+ 1 ->> index, datastring);
			endfor;
			syswrite(poprawdevout, datastring, bpr_s);
		endfor;
	else
		/* use 4-bit connection: send one nibble per byte: low nibble first */
		bpr_a * 2 -> bpr_s;

		array.arrayvector -> avec;  ;;; get at the underlying arrayvec
		inits(bpr_s) -> datastring; ;;; get a string to copy it into in nibbles

		pwmsendmessage(y, x, height, width,
						bpr_s,  ;;; bytes-per-row sent
						depth,  ;;; bits per pixel
						4,      ;;; bits per byte
						Pwms_gfxdumpraster, true);

		setrawmode(poprawdevout, true);

		0 -> index;
		for y from y1 to y2 do
			0 -> si;
			for i from 1 to bpr_a do
				fast_subscrs(index fi_+ i, avec) -> byte;
				(byte fi_&& 2:1111) fi_|| 2:01000000    ;;; so it isn't a control char
							-> fast_subscrs(si fi_+ 1 ->> si, datastring);
				(byte fi_>> 4) fi_|| 2:01000000 ;;; so it isn't a control char
							-> fast_subscrs(si fi_+ 1 ->> si, datastring);
			endfor;
			syswrite(poprawdevout, datastring, bpr_s);
			index + bpr_a -> index;
		endfor;

	endif;
	sysflush(poprawdevout);
	setrawmode(poprawdevout, false);
enddefine;

endsection;


/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - Altered for new names:
		pwm_gfxdumpraster       -> pwm_dump_raster
		newpwmrasterarray       -> pwm_make_rasterarray
--- Rob Duncan, Apr  4 1989
		Made to use LIB SYSDEFS to determine whether the system is BSD
		compatible rather than testing -sys_os_type-
--- John Gibson, Nov 11 1987
		Replaced -popdevraw- with -poprawdevout-
--- John Williams, May 29 1987 - fixed to handle Clisp style arrays
--- Ben Rubinstein, Apr 11 1987 - made raw mode dependent on os type
--- Ben Rubinstein, Apr  5 1987 - now handles all remote cases
*/
