/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_iconlocation.p
 > Purpose:		Set or get the position of a window's icon
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMWINDOWS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib  => pwm_iconlocation;

uses pwmsequences;

define pwm_iconlocation(win) -> vec;
	lvars win vec temp;
	checkpwmwinid(win) -> win;
	if (getpwmreport(win, Pwms_geticonlocat, Pwms_repiconlocat) == 3) then
		consvector(2) -> vec -> temp;
		unless temp == win do false -> vec endunless;
	else
		false -> vec
	endif
enddefine;

define updaterof pwm_iconlocation(vec, win);
	lvars win vec;
	pwmsendmessage(subscrv(2, vec), subscrv(1, vec),
			if win==pwmnxtwin then PwmnxtwinID else checkpwmwinid(win) endif,
			Pwms_seticonlocat, pwmflushmessage);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - renamed from pwm_icon_location
--- Ben Rubinstein, Mar 17 1987 - added patch for -pwmnxtwin- facility
*/
