/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:			C.pwm/lib/pwm/pwm_itemhandler.p
 > Purpose:			Distribute mouse input events within PWM window
 > Author:			Ben Rubinstein, Feb 20 1987 (see revisions)
 > Documentation:	HELP * PWMINPUT
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib  => pwm_itemhandler, pwmitemarea;

global vars pwmitemarea;

;;; each item is represented by a four element vector, as:
;;;			event-name | list-of-names | false
;;;			button | list-of-buttons | false
;;;			box	(a vector: left,top,right,bottom)
;;;			procedure

;;; takes an event spec (event name, names, or false=wildcard; mouse button,
;;; buttons, or false=wildcard; and area spec or false=wildcard) and a list
;;; of other event specs; if there is some possible event that would match
;;;	both the explicitly-given spec and one of the specs in the list,
;;; returns the one from the list; else false
;;;
define events_overlap(ename, ebutton, area, event_list);
	lvars ename ebutton area event_list ivec;

	;;;	return true iff at least one point is in both boxes
	define lconstant boxesoverlap(box1, box2);
		lvars box1, box2;

		unless box1 and box2 do return(false) endunless;

		fi_max(fast_subscrv(1, box1), fast_subscrv(1, box2))
			<= fi_min(fast_subscrv(3, box1), fast_subscrv(3, box2))
		and
			fi_max(fast_subscrv(2, box1), fast_subscrv(2, box2))
				<= fi_min(fast_subscrv(4, box1), fast_subscrv(4, box2));
	enddefine;

	define lconstant thingsoverlap(thing1, thing2);
		lvars thing1 thing2 thing;

		define lconstant checkthing(thing);
			lvars thing;
			if thing2.islist then
				lmember(thing, thing2)
			else
				thing == thing2
			endif
		enddefine;

		unless thing1 and thing2 do return(true) endunless;

		if thing1.islist then
			for thing in thing1 do
				if checkthing(thing) then return(true) endif;
			endfor;
			false
		else
			checkthing(thing1)
		endif
	enddefine;

	until event_list == nil do
		destpair(event_list) -> event_list -> ivec;

		if thingsoverlap(ename, subscrv(1, ivec))
		and thingsoverlap(ebutton, subscrv(2, ivec))
		and	boxesoverlap(area, subscrv(3, ivec)) then
			return(ivec);
		endif;
	enduntil;
	false;
enddefine;

;;; check that args are legitimate portions of an event spec; mishap if not,
;;; else return the area specifier (which may have been converted from a
;;; list (left-top-width-height) to the standard form of a vector
;;; (left-top-right-bottom)
;;;
define lconstant checkeventspec(word, button, area) -> area;
	lvars word button area x y w h;

	define lconstant checkeword(w) with_props false;
		lvars w;
		unless lmember(w, [press release move]) do
			mishap(w, 1, 'MOUSE EVENT WORD NEEDED');
		endunless;
	enddefine;

	if word.isword then checkeword(word)
	elseif word.islist then applist(word, checkeword)
	elseif word then
		mishap(word, 1, '(LIST OF) MOUSE EVENT WORDS OR FALSE NEEDED');
	endif;

	if area.islist then
		area.explode -> h -> w -> y -> x;
		{% x, y, x + w, y + h %} -> area;
	endif;

	if area.isvector then
		appdata(area, checkinteger(% 0, false %));
		unless fast_subscrv(1, area) fi_< fast_subscrv(3, area)
		and	fast_subscrv(2, area) fi_< fast_subscrv(4, area) do
			mishap(area, 1, 'impossible area');
		endunless;
	elseif area then
		mishap(area, 1, 'bad area specification')
	endif;
enddefine;

define itemise_mouseinput(event, elist, defproc);
	lvars	event, elist, defproc, x, y, evword, evbutton,
			pateword, patebutton, patebox, ivec;

	;;;	return true iff (x, y) is in box
	define lconstant pointinbox(x, y, box);
		lvars x y box;
		x fi_>= fast_subscrv(1, box) and
		y fi_>= fast_subscrv(2, box) and
		x fi_<= fast_subscrv(3, box) and
		y fi_<= fast_subscrv(4, box);
	enddefine;

	fast_subscrv(1, event) -> evword;
	fast_subscrv(2, event) -> evbutton;
	fast_subscrv(3, event) -> x;
	fast_subscrv(4, event) -> y;

	until elist == nil do
		destpair(elist) -> elist -> ivec;
		subscrv(1, ivec) -> pateword;
		subscrv(2, ivec) -> patebutton;
		subscrv(3, ivec) -> patebox;

		if pateword and pateword.islist then
			nextunless(lmember(evword, pateword));
		elseif pateword then
			nextunless(pateword == evword);
		endif;
		if patebutton and patebutton.islist then
			nextunless(lmember(evbutton, patebutton));
		elseif patebutton then
			nextunless(patebutton == evbutton);
		endif;
		nextif(patebox and not(pointinbox(x, y, patebox)));
		patebox -> pwmitemarea;
		chain(event, subscrv(4, ivec));
	enduntil;

	false -> pwmitemarea;
	chain(event, defproc);
enddefine;

define pwm_itemhandler(window, word, button, area) -> proc;
	lvars word button area proc splitter window default_proc list;

	checkeventspec(word, button, area) -> area;
	pwm_eventhandler(window, "press") -> splitter;

	if splitter.isclosure and splitter.pdpart == itemise_mouseinput then
		frozval(1, splitter) -> list;
		frozval(2, splitter) -> default_proc;
	else
		[] -> list;
		if splitter then splitter else erase endif -> default_proc;
	endif;

	if word or button or area then
		events_overlap(word, button, area, list)
	else
		default_proc;
	endif -> proc;
enddefine;

define updaterof pwm_itemhandler(proc, window, word, button, area);
	lvars word button area proc splitter window default_proc list item;

	checkeventspec(word, button, area) -> area;

	pwm_eventhandler(window, "press") -> splitter;
	if splitter.isclosure and splitter.pdpart == itemise_mouseinput then
		frozval(1, splitter) -> list;
		frozval(2, splitter) -> default_proc;
	else
		[] -> list;
		if splitter then splitter else erase endif -> default_proc;
	endif;

	if proc.isprocedure then
		if word or button or area then
			if (events_overlap(word, button, area, list) ->> item) then
				if word = subscrv(1, item)
				and button = subscrv(2, item)
				and area = subscrv(3, item)
				and pdprops(proc) = pdprops(subscrv(4, item)) then
					proc -> subscrv(4, item)
				else
					mishap(word, button, area, proc, item, 5, 'OVERLAPPING EVENTS');
				endif
			else
				{% word, button, area, proc %} :: list -> list;
			endif
		else
			proc -> default_proc;
		endif;
	elseif proc then
		mishap(proc, 1, 'PROCEDURE NEEDED');
	else
		if word or button or area then
			[% until list == nil do
					list.destpair -> list -> item;
					if word = subscrv(1, item)
					and button  = subscrv(2, item)
					and area = subscrv(3, item) then
						false -> item;
						list.explode;
						nil -> list;
					else
						item
					endif
				enduntil %] -> list;
			if item then
				mishap(word, button, area, 3,
							'ATTEMPT TO REMOVE NON-EXISTENT ITEM');
			endif;
		else
			mishap(word, button, area, 3, 'CAN\'T REMOVE DEFAULT PROC');
		endif;
	endif;

	itemise_mouseinput(% list, default_proc %)
						->> pwm_eventhandler(window, "press")
						->> pwm_eventhandler(window, "release")
						-> proc;

	'pwm_itemhandler: ' >< (intof(list.length /4)) >< ' items' -> pdprops(proc);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Aug 29 1989
		Renamed from -pwmitemhandler-.  Altered for new name
		-pwm_eventhandler- replacing -pwmeventhandler-
--- Ben Rubinstein, Mar 23 1987 - allows re-assignment in limited cases
*/
