/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_load_font.p
 > Purpose:		Instruct the PWM to load a local font definition file
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_load_font;

uses pwmsequences;

define pwm_load_font(string) -> fid;
	lvars string fid;
	if getpwmreport(string, Pwms_gfxloadfont, Pwms_newfontres) == 4 then
		pwmnewfontid(consvector(sys_fname_name(string), 4));
	else
		false
	endif -> fid;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - renamed from pwm_gfxloadfont
 */
