/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:			C.pwm/lib/pwm/pwm_load_raster.p
 > Purpose:			Read a raster from the PWM
 > Author:			Ben Rubinstein, Mar 27 1987 (see revisions)
 > Documentation:	HELP *PWMRASTERS
 > Related Files:	LIB *PWM_DUMPRASTER
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_load_raster;

;;; get a raster for the given rectangle of the current graphics window
;;;
define pwm_load_raster(left, top, width, height) -> arr;
	lvars row i left top width height depth s, arr = false,
			bpls 	;;; bytes per line, sent
			bplr 	;;; bytes per line, to be recieved
			bpb		;;; bits per byte (sent)
			;

	setrawmode(poprawdevin, true);
	if getpwmreport(height, width, top, left,
						Pwms_gfxloadraster, Pwms_gfxrastercome) == 5 then
		-> bpls -> height -> width -> depth -> bpb;

		arrayvector(
			pwm_make_rasterarray([% 1, width, 1, height%], depth) ->> arr) -> s;

		if ((width * depth) // 8 -> bplr) > 0 then bplr + 1 -> bplr endif;

		1 -> row;
		repeat height times
			sysread(poprawdevin, row, s, bplr) ->;
			if (bpls fi_> bplr) then erase(sysread(poprawdevin, ' ', 1)) endif;
			row fi_+ bplr -> row;
		endrepeat;
	endif;
	setrawmode(poprawdevin, false);
enddefine;

endsection;


/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - Altered for new names:
		pwm_gfxloadraster       -> pwm_load_raster
		newpwmrasterarray       -> pwm_make_rasterarray
--- John Gibson, Nov 11 1987
		Replaced -popdevraw- with -poprawdevin-
 */
