/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        	C.pwm/lib/pwm/pwm_make_cycleitem.p
 > Purpose:     	A PWM item with a list of values it cycles through
 > Author:      	Ben Rubinstein, Mar 15 1987 (see revisions)
 > Documentation:   HELP PWMITEMS
 > Related Files:   LIB *PWMTOGGLEITEM
 */
compile_mode :pop11 +strict;

uses pwm_itemhandler;
uses conspwmitem;
uses pwmrasterop;

section $-library$-pwmlib => pwm_make_cycleitem;

define lconstant rotate_vector(vec, len) -> oldfirst;
	lvars vec oldfirst len index;
	subscrv(1, vec) -> oldfirst;
	for index from 1 to len fi_- 1 do
		subscrv(index fi_+ 1, vec) -> subscrv(index, vec)
	endfor;
	oldfirst -> subscrv(len, vec);
enddefine;

define lconstant rotate_to_item(item, vec, len) -> item_found -> newvec;
lvars item vec len index vec_back vec_front item_found newvec;

	1 -> index;

	while fast_front(vec(index)) /= item and index < len
	do
		index fi_+ 1 -> index;
	endwhile;

	if fast_front(vec(index)) = item
	then
		explode(vec);
		consvector(len - index) -> vec_back;
		consvector(index) -> vec_front;

		vec_back <> vec_front -> newvec;

		vec(index) -> item_found;
	else
		mishap(item,'attempt to assign bad value');
	endif;
enddefine;

;;; (a closure of) this procedure actually catches the event
;;;
define lconstant catchcycle(ev, window, x, y, item);
	lvars ev window x y item l newval;
	dlocal pwmgfxsurface = window,
			pwmgfxfont = pwmstdfont,
			pwmrasterop = PWM_SRC;
	datalength(item.pi_value) -> l;
	if ev.isvector and subscrv(1, ev) == "release" then
		return
	elseif ev.isvector then ;;; actual press
		rotate_vector(item.pi_value, l) -> ev;
	elseif ev then                  ;;; please return current  value
		return(fast_front(subscrv(item.pi_value.datalength, item.pi_value)));
	else
		-> newval;          ;;; new value
		rotate_to_item(newval,item.pi_value,l) -> ev -> item.pi_value;
	endif;
	pwm_draw_text(x, y, ev.fast_back);
	if item.pi_proc then (item.pi_proc)(ev.fast_front) endif;
enddefine;

;;; pwm_make_cycleitem(<window-id>, <integer:X>, <integer:Y>,
;;;                 <vector>, <string>, <procedure>) -> <vector:Item>
;;;
;;; window, x, and y define where item goes (x and y are top left corner)
;;; vector is list of values, first one the initial value
;;;         if any value in vector is a list, it is taken as [label value]
;;; string is the label
;;; procedure is called whenever value changed
;;;
define pwm_make_cycleitem(window, x, y, values, label, proc) -> item;
	lvars window x y w h b l vl c cx cy m values label proc item box;
	dlocal pwmrasterop, pwmgfxsurface = window, pwmgfxfont = pwmstdfont;

	;;; take a value, and adjust tally of max length of printable versions
	define lconstant valmaxlen(o);
		lvars o;
		if o.islist or o.isvector then o(1) -> o endif;
		max(vl, datalength(o >< '')) -> vl;
	enddefine;

	;;; take a value, and return pair of (value, printable version): printable
	;;; version padded with spaces to VL characters
	define lconstant valprintable(o);
		lvars o po l1 l2;
		dlocal pop_pr_quotes = false, cucharout = identfn;
		if o.islist or o.isvector then
			o(1) -> po; o(2) -> o;
		else o -> po;
		endif;
		stacklength() -> l;
		sys_syspr(po);
		stacklength() - l -> l;
		repeat (vl - l) times ` ` endrepeat;
		consstring(vl) -> po;
		conspair(o, po);
	enddefine;

	pwmstdfont.pwm_fontwidth -> w;
	pwmstdfont.pwm_fontheight -> h;
	pwmstdfont.pwm_fontbaseline -> b;

	0 -> vl; applist(values, valmaxlen);        ;;; get VL, max length of value
	{% applist(values, valprintable) %} -> values;
	vl * w -> vl;
	w * label.datalength -> l;

	x + l + vl + w + 4 -> cx;
	y + 2 + h -> cy;

	{% x, y, cx, cy %} -> box;

	;;; make up an "item" record
	conspwmitem(label, window, values, [press release], [1 2], box, false,
					proc) -> item;

	;;; turn proc into catcher
	catchcycle(% window, x + 2 + l + w, y + b + 2, item %) -> proc;

	;;; and smash catcher into item (!)
	proc -> item.pi_catch;

	;;; assign it before drawing anything in case it's illegal
	proc -> pwm_itemhandler(window, [press release], [1 2], box);

	empty_box(x,y, cx-x, cy-y + 1);
	PWM_SRC -> pwmrasterop;
	pwm_draw_text(x + 2, y + b + 2, label);
	pwm_draw_text(x + 2 + l + w, y + b + 2,
				fast_back(rotate_vector(values, values.datalength)));
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Julian Clinton, Apr 30 1991 - added rotate_to_item to speed up
	updating in large cycle items (isl-fr.4253)
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwmcycleitem            -> pwm_make_cycleitem
		pwm_gfxtext             -> pwm_draw_text
		pwmitemhandler          -> pwm_itemhandler
		pwmgfxrasterop          -> pwmrasterop
--- Roger Evans, Jun 15 1988 - reversed order of last two args in
	conspwmitem call
--- Nic Ford, Aug  7 1987 - added a forgotten parameter (the window in which
							the item is placed) to the -conspwmitem- call.
--- Ben Rubinstein, Mar 27 1987 - fixed buggy text drawing
*/
