/* --- Copyright University of Sussex 1991.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_make_execitem.p
 > Purpose:     A button which calls a procedure, inverted the while
 > Author:      Ben Rubinstein, Mar 24 1987 (see revisions)
 > Documentation: HELP * PWMITEMS
 > Related Files: LIB PWMITEMHANDLER, PWMTOGGLEITEM, PWMCYCLEITEM, etc
 */
compile_mode :pop11 +strict;

uses conspwmitem;
uses pwm_itemhandler;
uses pwmrasterop;
uses pwm_draw_text;
uses pwm_wipe_area;

section $-library$-pwmlib => pwm_make_execitem;

;;; this is the procedure (a closure of) which catches the event
;;;
define lconstant catchexec(ev, x, y, w, h, item);
	lvars ev item x y w h user_rasterop;
	dlocal pwmgfxsurface, pwmrasterop;
	if ev == true then      ;;; please return value
		return(item.pi_value)
	elseunless ev then      ;;; assignment - pull value off stack
		-> ev;
	elseif ev.isvector and subscrv(1, ev) == "press" then
		true -> ev;
	else
		return;             ;;; presumably a 'release' event
	endif;
	if item.pi_value        ;;; we're in the middle of doing things
	or not(ev) then         ;;; assigned false
		return
	endif;

	true -> item.pi_value;          ;;; set flag in case we get done again
	pwmrasterop -> user_rasterop;
	PWM_NOTDST -> pwmrasterop;   ;;; inverting raster-op
	item.pi_window -> pwmgfxsurface;    ;;; select the window
	pwm_wipe_area(x, y, w, h);    ;;; invert button

	user_rasterop -> pwmrasterop;
	apply(item.pi_proc);            ;;; call the user procedure

	if ispwm_id(item.pi_window)
	and wved_is_live_window(item.pi_window) then    ;;; check item is still alive
		PWM_NOTDST -> pwmrasterop;   ;;; set r-op again in case proc changed it
		item.pi_window -> pwmgfxsurface;    ;;; select window again ditto
		pwm_wipe_area(x, y, w, h);    ;;; un-invert the button
		false -> item.pi_value;         ;;; unset flag to say we're finished
	endif;
enddefine;

;;; pwm_make_execitem(<window-id>, <integer:X>, <integer:Y>,
;;;                 <string>, <procedure>) -> <pwmitem>
;;;
;;; window, x, and y define where item goes (x and y are top left corner)
;;; string is the label
;;; procedure is called whenever thing is hit
;;;
define pwm_make_execitem(window, x, y, label, proc) -> item;
	lvars window x y h l label proc item box;
	dlocal pwmrasterop, pwmgfxsurface = window, pwmgfxfont = pwmstdfont;

	unless proc.isprocedure do
		mishap(proc, 1, 'PROCEDURE NEEDED');
	elseunless window.pwm_windowtype do
		mishap(window, 1, 'PWM WINDOW NEEDED');
	elseunless label.isstring do
		mishap(label, 1, 'STRING NEEDED');
	else
		checkinteger(x, 0, false);
		checkinteger(y, 0, false);
	endunless;

	pwmstdfont.pwm_fontheight -> h;

	;;; l is length in pixels of the label
	pwmstdfont.pwm_fontwidth * label.datalength -> l;

	;;; the full area covered by the item
	{% x, y, x+l+3, y+h+2 %} -> box;

	conspwmitem(label, window, false,
				[press release], 1, box, false, proc) -> item;

	;;; turn proc into catcher, with item as frozen value
	catchexec(% x + 1, y + 1, l +2, h + 1, item %) -> proc;

	;;; and smash catcher into item
	proc -> item.pi_catch;

	;;;; assign catcher before we draw it, to make sure it doesn't overlap
	proc -> pwm_itemhandler(window, [press release], 1, box);

	empty_box(x, y, l + 4, h + 3);  ;;; draw the box (defined in LIB CONSPWMITEM)
	PWM_SRC -> pwmrasterop;      ;;; and draw the label inside it
	pwm_draw_text(x + 2, y + pwmstdfont.pwm_fontbaseline + 2, label);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Julian Clinton, May  1 1991
		In -catchexec- : added test -ispwm_id- before call to -wved_is_live_window-.
		See bugreport FR 4160.
--- Gareth Palmer, Sep  8 1989
		In -catchexec- : added test -wved_is_live_window- after call to user
		procedure, replacing simple test against false.  See bugreport
		FR 4268.  Added -h- to list of lvars in -catchexec-.  Added use of
		-user_rasterop- in -catchexec- to esure correct rasterop used
		when -item- is applied; see bugreport FR 4270.
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwmexecitem             -> pwm_make_execitem
		pwm_gfxwipearea         -> pwm_wipe_area
		pwm_gfxtext             -> pwm_draw_text
		pwmitemhandler          -> pwm_itemhandler
		pwmgfxrasterop          -> pwmrasterop
--- Roger Evans, Nov 10 1987 - added check to catchexec to make sure
	the item is still active after running the user procedure before
	attempting to un-invert it.
--- Ben Rubinstein, Mar 25 1987 - added window to item record
*/
