/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 > File:            C.pwm/lib/pwm/pwm_make_labelitem.p
 > Purpose:         A label string that takes input from the keyboard
 > Author:          Anthony Worrall (of Reading University), Nov 4 1987 (see revisions)
 > Documentation:   HELP * PWMITEMS
 > Related Files:   LIB *PWMITEMHANDLER, *PWMTOGGLEITEM, *PWMCYCLEITEM, etc
 */
compile_mode :pop11 +strict;

uses poppwmlib;
uses conspwmitem;
uses pwm_itemhandler;
uses pwmrasterop;
uses pwm_draw_text;
uses pwm_wipe_area;

section $-library$-pwmlib =>
				pwm_make_labelitem pwmselectlabelitem pwmdeselectlabelitem
				pwmselectnextlabelitem pwmlabelcompile;

lvars cpos=0;

define pwmlabelcompile(item);
	lvars item;
	pop11_compile(stringin(pwm_itemvalue(item)));
enddefine;

/*
Catch characters from keyboard and up date label
allowed values for input are
	true    select update label and select
	false   deselect label
	vector  { "character", c }.
If the character c is a newline or return then the procedure proc is called
if it is not false with argument item.
*/

define catchcharlabel(input,window,item,lstart_x,lstart_y,llen,user_proc);
lvars input,window,item,lstart_x,lstart_y,llen,user_proc;
dlocal pwmgfxsurface = window, pwmgfxfont = pwmstdfont, pwmrasterop = PWM_CLR;
lvars label,c = writeable inits(1),len,fw,fh,fb,overflow, flowover;
	(item.pi_value)(1) -> label;
	(item.pi_value)(2) -> cpos;
	datalength(label) -> len;
	pwm_fontwidth(pwmgfxfont) -> fw;
	pwm_fontheight(pwmgfxfont) -> fh;
	pwm_fontbaseline(pwmgfxfont) -> fb;
	if input then   ;;;selecting or selected for input;
		if input.isvector and input(1) = "character" then
			input(2) -> c(1);   ;;;force character
			switchon c(1)
			case == 8 orcase == 127 then
				if len == 0 or cpos == 0 then
					return;
				else
				if cpos == len then
					allbutlast(1, label);
				elseif cpos == 1 then
					allbutfirst(1, label);
				else
				substring(1,cpos fi_- 1,label) <>
				substring(cpos fi_+ 1,len - cpos /* fi_-1 */ ,label);
				endif ->> label -> (item.pi_value)(1);
				cpos fi_- 1 ->> cpos -> (item.pi_value)(2);
				len fi_- 1 -> len;
				endif;
			case == 2 then
				if cpos > 0
				then cpos fi_- 1 ->> cpos -> (item.pi_value)(2);
				else return;
				endif;
			case == 6 then
				if cpos < len
				then cpos fi_+ 1 ->> cpos -> (item.pi_value)(2);
				else return;
				endif;

			case == 13 orcase == 10 then
				if user_proc then
					if user_proc.isprocedure then
						user_proc(item);
					else
						valof(user_proc)(item);
					endif;
					return();
				endif;
			case > 31 andcase < 127 then
				if cpos == len then
					label >< c ->> label;
				elseif cpos == 0 then
					c >< label ->> label;
				else
					((substring(1,cpos, label) >< c)
					>< substring(cpos fi_+ 1, len fi_- cpos /* fi_- 1 */, label))
						->> label;
				endif -> (item.pi_value)(1);
				cpos fi_+ 1 ->> cpos -> (item.pi_value)(2);
				len fi_+ 1 -> len;
			endswitchon;
		endif;
		;;;clear label area
		PWM_CLR -> pwmrasterop;
		pwm_wipe_area(lstart_x,lstart_y-1,fw*llen,fh);
		;;;get only the bit of the label to be displayed
		if (len-llen ->> overflow) >= 0 then
			if cpos < len then
				if (cpos - llen  ->> flowover) >= 0 then
					allbutlast(len-cpos-1,allbutfirst(flowover+1,label));
					0->overflow;
				else
					allbutlast(overflow,label);
					flowover->overflow;
				endif;
			else
				allbutfirst(overflow+1,label);
				cpos-llen -> overflow;
			endif;
		else
			min(overflow, cpos-llen) -> overflow;
			label;
		endif -> label;
		;;;display the visible part of the label
		PWM_SRC -> pwmrasterop;
		pwm_draw_text(lstart_x,lstart_y+fb,label);
		;;; set the cursor
		PWM_NOTDST -> pwmrasterop;
		pwm_wipe_area(lstart_x+fw*(llen+min(-1,overflow)),lstart_y,fw,fh-2);
	else    ;;; deselect;
		;;;check if the item still exists;
		if item.pi_window then
		  PWM_CLR -> pwmrasterop;
		  len-llen -> overflow;
		  pwm_wipe_area(lstart_x+fw*(llen+min(-1,overflow)),lstart_y,fw,fh-2);
		endif;
	endif;
enddefine;

/*
Procedure to allow an item to be deselected without selecting another one.
*/
define pwmdeselectlabelitem(item);
lvars window charcatcher item;
	item.pi_window -> window;
	pwm_eventhandler(window,"character") -> charcatcher;
	if charcatcher.isclosure and charcatcher.pdpart == catchcharlabel then
		;;;deselect old labelitem
		charcatcher(false);
	endif;
	;;;assign newcharcatcher to pwm_eventhandler
	pwm_inputcatcher -> pwm_eventhandler(window,"character");
enddefine;


/* Select a label item for input */
define pwmselectlabelitem(item);
lvars proc window charcatcher item i;
	item.pi_proc -> proc;
	item.pi_window -> window;
	pwm_eventhandler(window,"character") -> charcatcher;
	if charcatcher.isclosure and charcatcher.pdpart == catchcharlabel then
		;;;deselect old labelitem
		charcatcher(false);
	endif;
	;;;select new labelitem
	proc(true);
	;;;assign newcharcatcher to pwm_eventhandler
	proc -> pwm_eventhandler(window,"character");
enddefine;

;;; a closure of this can be used as the procedure of a labelitem. When return
;;; is pressed then the label item next will be selected or the label item that
;;; is the value of next if next is a word.
define pwmselectnextlabelitem(current,next);
lvars next,current;
	if next.ispwmitem then
		pwmselectlabelitem(next);
	else
		pwmselectlabelitem(valof(next));
	endif;
enddefine;

/*
The closure on this catcher not only has to catch the event but is also called
by pwm_itemvalue with argument true to get the value and arguments v and false
to update the value of the item.
*/
define catchselectlabel(ev,item,user_proc);
	lvars ev,item,window,charcatcher user_proc i;
	if ev == true then          ;;; value requested
		return((item.pi_value)(1));
	elseif ev == false then     ;;; updating value
			-> ev;
		if ev == true then      ;;;if update value is true execute proc
			if (user_proc) then
				if user_proc.isprocedure then
					user_proc(item);
				else
					valof(user_proc)(item);
				endif;
			endif;
		else                     ;;;update value is string
			ev><'' -> (item.pi_value)(1);
		  datalength((item.pi_value)(1)) ->> cpos -> (item.pi_value)(2);
		endif;
	elseif ev.isvector and subscrv(1,ev) = "press" then
		pwm_eventhandler(item.pi_window,"character") -> charcatcher;
		if charcatcher == item.pi_proc then
			pwm_display_menu((item.pi_value)(1)><'\tClear\tStuff\t') -> i;
			switchon i =
			case 1 then
				'' -> (item.pi_value)(1);
			 0 ->> cpos -> (item.pi_value)(2);
			case 2 then
				pwm_get_selection();
			endswitchon;
		endif;
	else
		return;         ;;;presumably a release
	endif;

	pwmselectlabelitem(item);
enddefine;


define pwm_make_labelitem(window,x,y,nchar,prompt,label,user_proc) -> item;
lvars window,x,y,nchar,prompt,label,user_proc,item;
lvars fh, fw, fb, lstart, llen, box, proc, catcher, user_proc;
dlocal pwmrasterop, pwmgfxfont = pwmstdfont, pwmgfxsurface = window;

	pwmstdfont.pwm_fontheight -> fh;
	pwmstdfont.pwm_fontwidth  -> fw;
	pwmstdfont.pwm_fontbaseline -> fb;
	;;; position of start of label
	x+2+fw*(datalength(prompt)+1) -> lstart;
	;;; position of end of label
	nchar*fw -> llen;

	;;; the full area covered by the item
	{% x, y, llen+lstart+2, y+fh+2 %} -> box;


	label >< '' -> label;
	datalength(label) -> cpos;
	conspwmitem(prompt, window, {% label, cpos %},
				[press release], 1, box, false, false) -> item;

	;;;character handler for this label
	 catchcharlabel(%window,item,lstart,y+2,nchar,user_proc%) -> proc;
	;;; and smash catcher into item
	proc -> item.pi_proc;

	;;; turn proc into catcher, with item as frozen value
	catchselectlabel(%item,user_proc%) -> catcher;

	;;; and smash catcher into item
	catcher -> item.pi_catch;

	;;;; assign catcher before we draw it, to make sure it doesn't overlap
	catcher -> pwm_itemhandler(window, [press release], 1, box);

;;;    empty_box(x, y, lstart-x+llen + 2, fh + 3);  ;;; draw the box (defined in LIB CONSPWMITEM)
	PWM_SRC -> pwmrasterop;      ;;; and draw the label inside it
	pwm_draw_text(x + 2, y + fb + 2, prompt);
	lstart - (fw div 2) -> x;
	pwm_draw_line(x,y,x+llen+fw+1,y,x+llen+fw+1,y+fh+2,x,y+fh+2,x,y,5);
	;;; update label
	pwmselectlabelitem(item);
enddefine;


endsection;


/* --- Revision History ---------------------------------------------------
--- Simon Nichols, Nov 25 1991
		Fixed  -pwm_make_labelitem- to draw box in the correct location.
		See bugreport isl-fr.4388.
Added pwmlabelcompile                                          ADW
Added selectlabelitem and deselectlabelitem                    ADW 12/8/88
Added check that item still exists when trying to deselect it. ADW 26/10/88
Added menu for selected label item.                            ADW 30/3/89
Ammended visual appearance converted to run under standard
PWMTOOL.                                                       DJW 16/10/89
Added full editing: ^B (BACK) ^F (FORWARD) of text string      DJW 18/10/89
Tidied up refreshing of text input string                      DJW 19/10/89
*/
