/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 > File:            C.pwm/lib/pwm/pwm_make_listitem.p
 > Purpose:         A PWM item with a list of values
 > Author:          Anthony Worrall (of Reading University), Nov 14 1988 (see revisions)
 > Documentation:   HELP * PWMITEMS
 > Related Files:   LIB * PWMCYCLEITEM
 */
compile_mode :pop11 +strict;

uses poppwmlib;
uses conspwmitem;
uses pwm_itemhandler;
uses pwmrasterop;
uses pwm_draw_text;
uses pwm_wipe_area;

section $-library$-pwmlib => pwm_make_listitem pwmlist_delete pwmlist_append pwmlist_contents;

lvars TRACKING=false, oldmousexit=erase, oldmove=erase, oldoffset=0;
lvars old_index=(-1), index=(-1), clicktime = {%0,sys_real_time()%};

lvars clickdelay = 25;    ;;; 1/100s
lvars clickdelta = 300; ;;; Tune according to machine

define lconstant display_slider(window,x,y,rows,offset,nvals);

	lvars window x y values s bs bo nvals rows fh fw offset;
	dlocal pwmgfxsurface = window,
		 pwmgfxfont = pwmstdfont,
		 pwmrasterop = PWM_NOTDST;

	pwmgfxfont.pwm_fontheight -> fh;
	pwmgfxfont.pwm_fontwidth -> fw;
	( rows - 2 ) * fh -> s;
	if nvals = 0 then s else min(s,max(1,round(s*rows/nvals))) endif; -> bs;
	if nvals = rows
	then 0
	else min(max(round((s-bs)*offset/(nvals - rows)),0),s-bs)
	endif -> bo;

	pwm_wipe_area(x-2*fw,y+fh+bo,2*fw-3,bs);
enddefine;

define lconstant displaylist(window,x,y,width,rows,values,offset,nvals);
	lvars window x y values index i r nvals width rows fh fb offset;
	dlocal pwmgfxsurface = window,
		 pwmgfxfont = pwmstdfont,
		 pwmrasterop = PWM_CLR;

	pwmgfxfont.pwm_fontheight -> fh;
	pwmgfxfont.pwm_fontbaseline -> fb;

	;;;clear area;
	pwm_wipe_area(x,y,width,fh*rows);
	PWM_SRC -> pwmrasterop;

	values(nvals) -> index;

	min(rows,nvals)-1 -> r;
	for i from 0 to r do
		pwm_draw_text(x, y + fb + i*fh, fast_back(values(i + offset)));
	endfor;

	if index >= offset and index < offset+rows then
		PWM_NOTDST -> pwmrasterop;
		pwm_wipe_area(x,y+(index-offset)*fh,width,fh);
	endif;

enddefine;

;;; take a value, and return pair of (value, printable version): printable
;;; version padded with spaces to VL characters
define lconstant valprintable(o,vl);
	lvars o po vl l;
	if o.islist or o.isvector then
		o(1) -> po; o(2) -> o;
	else o -> po;
	endif;
	po >< '' -> po;                 ;;;convert po into printable form
	length(po) -> l;
	if l > vl then
		substring(1,vl,po><'');   ;;;clip string only needed for pwmcycle_append
	else
		po;
		repeat (vl - l) times ><' ' endrepeat   ;;;padding
	endif -> po;
	conspair(o, po);
enddefine;

;;; mouse handlers

define lconstant pwmlist_exit(x,y,width,rows,values,offset,nvals,fh);
	lvars x,y,width,rows,values,offset,nvals,fh;
	if index >= offset and index < offset+rows then
		pwm_wipe_area(x,y+(index-offset)*fh,width,fh);
		-1 ->> index -> values(nvals);
	endif;
enddefine;

define lconstant pwmlist_mousexit(ev,window,proc);
	lvars proc window ev;
	dlocal pwmgfxsurface = window, pwmrasterop = PWM_NOTDST;
	proc();
	oldmousexit -> pwm_eventhandler(window,"mousexit");
	if TRACKING then
		oldmove -> pwm_eventhandler(window,"move");
	endif;
	false -> TRACKING;
enddefine;

define lconstant display_move(ev,window,x,y,width,rows,values,offset,nvals,fh,s,bs);
	lvars ev,window,x,y,width,rows,values,offset,nvals,fh,s,bs,bo;
	ev(4) - y - fh -> bo;
	round(bo * ( nvals - rows ) / ( s - bs )) -> offset;
	max(0,min(offset,max(nvals-rows,0))) -> offset;
	if oldoffset /== offset then
		displaylist(window,x,y,width,rows,values,offset,nvals);
		offset -> oldoffset;
	endif;
enddefine;

define lconstant pwmlist_move(ev,window,x,y,width,rows,values,offset,nvals,fh);
	lvars ev,window,x,y,width,rows,values,offset,nvals,fh,i;
	lvars wipeproc;
	dlocal pwmgfxsurface = window, pwmrasterop;
	(ev(4) - y + 1) div fh -> i;  ;;;calculate nearest line
	max(min(i,rows-1),0)  -> i;
	if i+offset < nvals then
		if index /== i+offset then
			PWM_NOTDST -> pwmrasterop;
			if index >= offset and index < offset+rows then
				pwm_wipe_area(%x,y+(index-offset)*fh,width,fh%);
			else
				identfn
			endif -> wipeproc;
			wipeproc();                 ;;;clear the selection
			PWM_NOTDST -> pwmrasterop;           ;;; mark line
			pwm_wipe_area(x,y+i*fh,width,fh);
			i+offset ->> index -> values(nvals);
		endif;
	endif;
enddefine;

;;; (a closure of) this procedure actually catches the event

define lconstant catchlist(ev, window, x, y, width, rows, item);
	lvars ev window x y newval values i nvals width rows fh fw fb offset;
	lvars s bs bo wipeproc update item;
	dlocal pwmgfxsurface = window,
		 pwmgfxfont = pwmstdfont,
		 pwmrasterop = PWM_SRC;

	pwmgfxfont.pwm_fontwidth -> fw;
	pwmgfxfont.pwm_fontheight -> fh;
	pwmgfxfont.pwm_fontbaseline-> fb;

	item.pi_value -> values;
	datalength(values)-2 -> nvals;
	values(nvals) -> index;
	values(nvals+1) -> offset;

	switchon ev
	case .isvector then
		if fast_subscrv(1, ev) == "release" then    ;;;handle release event
			if TRACKING then
				;;;restore old mouse handlers for both SELECT and SLIDER
				oldmousexit -> pwm_eventhandler(window,"mousexit");
				oldmove -> pwm_eventhandler(window,"move");
				switchon TRACKING =
				case "SELECT" then                  ;;; handle selection
				for i to clickdelta*(100-clickdelay) do endfor;
				sys_real_time()->clicktime(1);
					if index >= offset and index < offset+rows then
						if (item.pi_proc) then      ;;; call user proc
							(item.pi_proc)(fast_front(values(index)));
						endif;
					endif;
				clicktime(1)->clicktime(2);
				index -> old_index;
				case "SLIDER" then                      ;;;handle slider
					ev(4) - y - fh -> bo;               ;;;box offset
					( rows - 2 ) * fh -> s;             ;;;size of whole slider
					;;;size of box
					min(s-1,max(1,round(s*rows/nvals))) -> bs;
					;;;calculate first visible value
					round(bo * ( nvals - rows ) / ( s - bs )) -> offset;
					;;; clip between 0 and nvals
					max(0,min(offset,max(nvals-rows,0))) -> offset;
					offset -> values(nvals+1);                      ;;;store offset
					display_slider(window,x,y,rows,offset,nvals);   ;;;update slider
					;;; update displayed text
					displaylist(window,x,y,width,rows,values,offset,nvals);
				endswitchon;
				false -> TRACKING;   ;;;tracking finished
			endif;
		else                                ;;;handle PRESS event
/*
			if TRACKING then
				;;;rapid clicking of mouse loses release events !!!!
				;;;simulate a mouse exit to reset everything
				if (pwm_eventhandler(window,"mousexit")) then
					pwm_eventhandler(window,"mousexit")(false);
				endif;
			return;
			endif;
*/
			if ev(4) < y-2 then         ;;;on label display selected value
				unless (index >= offset and index < offset+rows) or (index ==
			 -1) then
					;;;make index the top line unless it is too near the end
					display_slider(window,x,y,rows,offset,nvals);
					min(index, max(nvals-rows,0))  ->> offset -> values(nvals+1);
					displaylist(window,x,y,width,rows,values,offset,nvals);
					display_slider(window,x,y,rows,offset,nvals);
				endunless;
			return
				;;; SELECTION
			elseif ev(3) > x then           ;;;selection
				unless nvals = 0 then       ;;;if no values then nothing to select
					pwmlist_move(ev,window,x,y,width,rows,values,offset,nvals,fh);

					"SELECT"-> TRACKING;        ;;;note tracking a SELECTION
					;;;store mouse exit handler
					pwm_eventhandler(window,"mousexit") -> oldmousexit;
					;;; eventhandler can return false but will not except false
					unless oldmousexit then erase -> oldmousexit; endunless;
					pwm_eventhandler(window,"move") -> oldmove;
					unless oldmove then erase -> oldmove; endunless;
					;;; store exit handler for SELECT
					pwmlist_mousexit(%window,pwmlist_exit(%x,y,width,rows,values,offset,nvals,fh%)%)
						-> pwm_eventhandler(window,"mousexit");
					pwmlist_move(%window,x,y,width,rows,values,offset,nvals,fh%)
						-> pwm_eventhandler(window,"move");
					;;; start tracking
					pwm_track_mouse(false,true);
				endunless;

				;;;SCROLL TEXT DOWN BUTTON
			elseif ev(4) < y+fh then
				max((offset - 1) ,0) -> i;
				unless (i = offset) then
					display_slider(window,x,y,rows,offset,nvals);
					i -> offset;
					PWM_SRC -> pwmrasterop;
					pwm_copy_raster(window,x,y,width,(rows-1)*fh,PWM_CLR,
						window,x,y+fh);
					PWM_SRC -> pwmrasterop;
					pwm_draw_text(x,y+fb,(values(offset).fast_back));
					if offset = index then
						PWM_NOTDST -> pwmrasterop;
						pwm_wipe_area(x,y,width,fh);
					endif;
					display_slider(window,x,y,rows,offset,nvals);
				endunless;

				;;;SCROLL TEXT DOWN BUTTON
			elseif ev(4) > y+(rows-1)*fh then            ;;;scroll text up
				min(offset+1, max(nvals-rows,0))  -> i;
				unless (i = offset) then
					display_slider(window,x,y,rows,offset,nvals);
					i -> offset;
					PWM_SRC -> pwmrasterop;
					pwm_copy_raster(window,x,y+fh,width,(rows-1)*fh,PWM_CLR,
						window,x,y);
					offset + rows - 1 -> i;
					PWM_SRC -> pwmrasterop;
					pwm_draw_text(x,y+(rows-1)*fh+fb,(values(i).fast_back));
					if i = index then
						PWM_NOTDST -> pwmrasterop;
						pwm_wipe_area(x,y+(rows-1)*fh,width,fh);
					endif;
					display_slider(window,x,y,rows,offset,nvals);
				endunless;
			else                                ;;;slider
				if nvals > rows then
					( rows - 2 ) * fh -> s;
					min(s-1,max(1,round(s*rows/nvals))) -> bs;
					display_slider(window,x,y,rows,offset,nvals);
					"SLIDER" -> TRACKING;
					pwm_track_mouse([%x-2*fw,y+fh,1,s-bs%],x-2*fw,ev(4),2*fw-3,bs,"bsheet",true);
					pwm_eventhandler(window,"mousexit") -> oldmousexit;
					unless oldmousexit then erase -> oldmousexit; endunless;
					pwm_eventhandler(window,"move") -> oldmove;
					unless oldmove then erase -> oldmove; endunless;
					pwmlist_mousexit(%window,
						 displaylist(%window,x,y,width,rows,values,offset,nvals%)
						 <>display_slider(%window,x,y,rows,offset,nvals%)
						 %) -> pwm_eventhandler(window,"mousexit");
					display_move(%window,x,y,width,rows,values,offset,nvals,fh,s,bs%)
						-> pwm_eventhandler(window,"move");
					offset->oldoffset;
				endif;
			endif;
			offset -> values(nvals+1);
			;;;END OF PRESS HANDLER
		endif;
	case = "DELETE" then
			-> newval;
		false -> update;
		display_slider(window,x,y,rows,offset,nvals);
		{%
			 nvals - 1 -> nvals;
			 fast_for i from 0 to nvals do
				 values(i) -> ev;
				 if ev.fast_front = newval then
					 if i >= offset and i < offset+rows then
						 true -> update;
					 endif;
					 if index > i then index - 1 -> index;
					 elseif index = i then -1 -> index
					 endif;
				 else
					 ev;
				 endif
			 endfor;
			 index;
			 0,
			 %} -> values;
		length(values) - 2 -> nvals;
		newanyarray([0 %nvals+1%],values) ->> values -> item.pi_value;
		min(offset, max(nvals-rows,0))  ->> offset -> values(nvals+1);
		if update then
			displaylist(window,x,y,width,rows,values,offset,nvals);
		endif;
		display_slider(window,x,y,rows,offset,nvals);

	case = "APPEND" then
			-> newval;
		display_slider(window,x,y,rows,offset,nvals);
		newanyarray([0 ^(nvals+2)], {%
				 fast_for i from 0 to nvals fi_-1 do
					 values(i);
				 endfor;
				 valprintable(newval,width div fw);
				 index;
				 offset,
				 %}) ->> values -> item.pi_value;
		if nvals < rows then
			displaylist(window,x,y,width,rows,values,0,nvals+1);
		endif;
		display_slider(window,x,y,rows,offset,nvals+1);

	case = "UPDATE_PROC" then
			-> item.pi_proc;

	case = "UPDATE_CONTENTS" then
			-> values;
		display_slider(window,x,y,rows,offset,nvals);
		{%  if values.islist
			 then applist
			 else appdata
			 endif(values, valprintable(%width div fw%)),-1,0
			 %} -> values;
		length(values) - 2 -> nvals;
		newanyarray([0 %nvals+1%],values) ->> values -> item.pi_value;
		0 -> offset;
		displaylist(window,x,y,width,rows,values,offset,nvals);
		display_slider(window,x,y,rows,offset,nvals);

	case = true then                  ;;; please return current  value
		if index = -1 then
		return(undef);
		else
		return(values(index).fast_front);
		endif;
	else
			-> newval;          ;;; new value
		if newval = undef then
			if index >= offset and index < offset+rows then
				PWM_NOTDST -> pwmrasterop;
				pwm_wipe_area(x,y+(index-offset)*fh,width,fh);
			endif;
			-1 -> values(nvals);
		else
			fast_for i from 0 to nvals fi_- 1 do
				values(i) -> ev;
			quitif(ev.fast_front = newval);
			endfor;
			if i= nvals do
				mishap(newval, 1, 'attempt to assign bad value');
			endif;
			PWM_NOTDST -> pwmrasterop;
			;;; set new selection
			i -> values(nvals);
			if i >= offset and i < offset+rows then
				;;;clear old selection;
				if index >= offset and index < offset+rows then
					pwm_wipe_area(x,y+(index-offset)*fh,width,fh);
				endif;
				pwm_wipe_area(x,y+(i-offset)*fh,width,fh);
			else
				display_slider(window,x,y,rows,offset,nvals);
				;;;make index the top line unless it is too near the end
				min(i, max(nvals-rows,0))  ->> offset -> values(nvals+1);
				displaylist(window,x,y,width,rows,values,offset,nvals);
				display_slider(window,x,y,rows,offset,nvals);
			endif;
			if (item.pi_proc) then
				(item.pi_proc)(newval);
			endif;
		endif;
	endswitchon;
enddefine;

define pwmlist_delete(item,val);
	lvars item val;
	(item.pi_catch)(val,"DELETE");
enddefine;

define pwmlist_append(item,val);
	lvars item val;
	(item.pi_catch)(val,"APPEND");
enddefine;

;;; return contents list of item. A list of lists, where the head of
;;; the list is the displayed item and the tail is the value passed to
;;; the procedure.
define pwmlist_contents(item);
	lvars i value_array item  contents_list nvals fr bk;
	item.pi_value -> value_array;
	datalength(value_array)-2 -> nvals;
	[% fast_for i from 0 to nvals fi_-1 do
			 [^(fast_back(value_array(i))) ^(fast_front(value_array(i)))];
		 endfor;
		 %];
enddefine;

define updaterof pwmlist_contents(new_values, item);
	lvars new_values, item;
	(item.pi_catch)(new_values,"UPDATE_CONTENTS");
enddefine;


;;; pwm_make_listitem(<window-id>, <integer:X>, <integer:Y>, <list|vector>,
;;;                   <string:L>, <integer:C>, <integer:R>,
;;;                   <procedure>) -> <vector:pwmItem>
;;;
;;; window, x, and y define where item goes (x and y are top left corner)
;;; vector is list of values, first one the initial value
;;;         if any value in vector is a list, it is taken as [label value]
;;; string is the label
;;; procedure is called whenever value changed
;;;
define pwm_make_listitem(window, x, y, values, label, cols, rows,proc) -> item;
	lvars window x y w h b cols rows cx cy i label values item box proc;
	dlocal pwmrasterop, pwmgfxsurface, pwmgfxfont = pwmstdfont;

	window -> pwmgfxsurface;
	-1 -> index;

	pwmstdfont.pwm_fontwidth -> w;
	pwmstdfont.pwm_fontheight -> h;
	pwmstdfont.pwm_fontbaseline -> b;

	if rows < 4 then
		max(4, min(rows,length(values))) -> rows;
	endif;

	{%  if values.islist
		 then applist
		 else appdata
		 endif(values, valprintable(%cols%)),-1,0 %} -> values;
	newanyarray([0 %length(values)-1%],values) -> values;

	max(cols,length(label)-2) -> cols;
	cols*w -> cols;

	x + cols + 4 + 2*w -> cx;
	y + 4 + rows*h+h -> cy;

	{% x, y, cx, cy %} -> box;

	;;; make up an "item" record
	conspwmitem(label, window, values, [press release], [1], box, false, proc)
		-> item;

	;;; turn proc into catcher
	catchlist(% window, x +2*w+2, y + 3 + h, cols, rows, item %) -> proc;

	;;; and put catcher into item (!)
	proc -> item.pi_catch;

	;;; assign it before drawing anything in case it's illegal
	proc -> pwm_itemhandler(window, [press release], [1], box);

	empty_box(x,y, cx-x, cy-y + 1);
	PWM_SRC -> pwmrasterop;
	pwm_draw_text(x+2,y+2+b,label);
	y + 1 + h -> y;
	pwm_draw_line(x,y,cx-1,y,2);
	pwm_draw_line(x+2*w,y,x+2*w,cy-1,2);

	pwm_draw_line(x,y+h,x+2*w,y+h,2);
	pwm_draw_line(x+3,y+h-2,x+w+1,y+2,x+2*w-1,y+h-2,x+3,y+h-2,4);

	pwm_draw_line(x,cy-h,x+2*w,cy-h,2);
	pwm_draw_line(x+3,cy-h+3,x+w+1,cy-2,x+2*w-1,cy-h+3,x+3,cy-h+3,4);

	y + 2 -> y;
	x + 2 + 2*w -> x;
	display_slider(window,x,y,rows,0,length(values)-2);
	min(rows - 1,length(values)-3) -> rows;
	for i from 0 to rows do
		pwm_draw_text(x, y + b + i*h, fast_back(values(i)));
	endfor;

enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
Added pwmlist_contents(item) and updaterof pwmlist_contents     RMB 21/12/88
Allowed values to be given in vector (or any subscriptable
data structure) as well as a list.                              ADW 17/1/89
Improved selection tracking, selection calculation, and
display_slider - display_list only called if required. Also
converted it so that it runs under standard PWMTOOL.            DJW 6/10/89
rows >= 4 to avoid display problems                             DJW 11/12/89
Added extra dlocals of pwmgfxsurface to prevent rasterops
appearing in base window                                        JJC 30/4/91
*/
