/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_make_menu.p
 > Purpose:     Store a menu definition with the PWM
 > Author:      Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:   HELP *PWMMENUS
 > Related Files:   LIB *PWM_DISPLAYMENU.P
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_make_menu;

uses pwmsequences;

define pwm_make_menu(string) -> mid;
	lvars string mid;
	if getpwmreport(string, Pwms_definemenu, Pwms_idresult) == 1 then
		-> mid;
		if mid > -1 then
			pwmnewmenuid(mid, gensym("M"))
		else
			string
		endif;
	else
		false
	endif -> mid;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - renamed from pwm_definemenu
--- John Williams, May 29 1987 - now returns 'string' if menu cannot
								 be compiled
*/
