/* --- Copyright University of Sussex 1992.  All rights reserved. ---------
 > File:	C.pwm/lib/pwm/pwm_make_menucall.p
 > Purpose:	display a menu and call a procedure depending on result
 > Author:	Ben Rubinstein, Dec 10 1986 (see revisions)
 > Documentation:	HELP *PWMMENUS
 > Related Files:	LIB *PWM_DISPLAYMENU
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_make_menucall;

define pwm_make_menucall(proclist, defproc);
	lvars proclist, defproc, len, sub, mresult, p;
	if proclist.islist then
		proclist.length, subscrl
	elseif proclist.isvector then
		proclist.datalength, subscrv
	else
		mishap(proclist, 1, 'LIST OR VECTOR (of procedures) NEEDED')
	endif -> sub -> len;
	pwm_display_menu() -> mresult;
	if mresult and mresult > 0 then
		if mresult > len then
			mishap(mresult, proclist, 2, 'no procedure for menu option')
		else
			if isident(sub(mresult, proclist) ->> p) then
				idval(p) -> p
			endif;
			if defproc then
				chain(mresult, p)
			else
				apply(p);
				mresult;
			endif
		endif
	elseif defproc then
		apply(mresult, defproc)
	else
		mresult
	endif
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- John Gibson, Dec 14 1992
		Changed to allow idents in proclist
--- Gareth Palmer, Sep  8 1989 - Altered for new names:
		pwm_menucall            -> pwm_make_menucall
		pwm_displaymenu         -> pwm_display_menu
--- John Williams, Jun  5 1987 - made 'pwm_menucall' global
 */
