/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_make_page.p
 > Purpose:		Make a new graphics 'page'
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_make_page;

uses pwmsequences;

define pwm_make_page(x, y);
	lvars x y;
	dlocal pop_pr_radix = 10, pop_pr_quotes = false;
	checkinteger(x, 1, false);
	checkinteger(y, 1, false);
	if (getpwmreport(y, x, Pwms_gfxnewpage, Pwms_idresult) == 1) do
		pwmnewpageid(x sys_>< 'x' sys_>< y);
	else
		false
	endif
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Aug  7 1989 - Renamed from -pwm_gfxnewpage-
 */
