/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_make_radioitem.p
 > Purpose:		"Radio-button" style items for PWM gfx windows
 > Author:		Ben Rubinstein, Mar 16 1987 (see revisions)
 > Documentation:	HELP *PWMITEMS
 > Related Files:	LIB * PWMTOGGLEITEM *PWMCYCLEITEM
 */
compile_mode :pop11 +strict;

uses conspwmitem;
uses pwm_itemhandler;
uses pwmrasterop;
uses pwm_draw_text;
uses pwm_wipe_area;

section $-library$-pwmlib => pwm_make_radioitem;

define lconstant catchradio(ev, x, w, curval, item);
	lvars ev x y w curval item values val;
	dlocal pwmgfxsurface, pwmrasterop;
	if ev.isvector and subscrv(1, ev) == "press" then
		subscrv(4, ev) -> ev;
		for val in item.pi_value do
			if ev fi_> fast_back(val) then
				val -> ev;
				quitloop;
			endif;
		endfor;
		if ev.isinteger then return else ev.fast_front endif;
	elseif ev.isvector then			;;; release - do nothing
		return
	elseif ev then 					;;; please return current  value
		return(curval.cont);
	endif -> ev;	;;; else  get new value off stack
	if ev = curval.cont then return endif;

	for val in item.pi_value do
		if val.fast_front = ev then false -> val; quitloop; endif;
	endfor;
	if val then mishap(ev, 1, 'attempt to assign bad value to radio item') endif;

	item.pi_window -> pwmgfxsurface;
	for val in item.pi_value do
		if val.fast_front = curval.cont then
			PWM_CLR -> pwmrasterop;
			pwm_wipe_area(x, val.fast_back + 4, w, w);
		elseif val.fast_front = ev then
			PWM_SET -> pwmrasterop;
			pwm_wipe_area(x, val.fast_back + 4, w, w);
		endif;
	endfor;
	(item.pi_proc)(ev ->> curval.cont);
enddefine;

define pwm_make_radioitem(window, x, y, initval, values, label, proc) -> item;
	lvars window x y label initval values proc item;
	lvars fw fh fb aw ah l bw bl vp va bt box;
	lconstant bo = 2;
	dlocal pwmrasterop,
			pwmgfxsurface = window,
			pwmalwaysflush = false,
			pwmgfxfont = pwmstdfont;

	;;; take a value, and adjust tally of max length of printable versions
	define lconstant valmaxlen(o);
		lvars o;
		if o.islist or o.isvector then o(1) -> o endif;
		max(aw, datalength(o >< '')) -> aw;
	enddefine;

	pwmstdfont.pwm_fontwidth -> fw;
	(pwmstdfont.pwm_fontheight ->> fh) - 4 -> bw;
	pwmstdfont.pwm_fontbaseline -> fb;

	applist(0 -> aw, values, valmaxlen);
	(aw * fw) + bw + (bo * 2) -> aw;
	values.length * fh + 4 -> ah;
	if label then
		max(aw, label.datalength * fw) -> aw;
		ah + 3 + fh -> ah;
	endif;
	x + 2 + aw - bo - bw -> bl;
	{% x, y, x + aw + 4, y + ah %} -> box;
	;;; make an item, although we can't fill in all the slots yet, so that
	;;; we can check the space is available.
	conspwmitem(label, window, false,
				[press release], 1, box, false, proc) -> item;

	;;; turn proc into catcher
	catchradio(% bl + 2, bw - 4, consref(initval), item %) -> proc;
	;;; and smash catcher into item
	proc -> item.pi_catch;
	;;; assign catcher before we draw it, to make sure it doesn't overlap
	proc -> pwm_itemhandler(window, [press release], 1, box);

	empty_box(x, y, aw + 4, ah);
	y + 2 -> y;
	if label then
		PWM_SRC -> pwmrasterop;
		pwm_draw_text(x + 2, y + fb, label);
		y + fh + 3 -> y;
	endif;
	[] -> item.pi_value;
	for va in values do
		if va.islist then va.hd, va.tl.hd -> va else va endif -> vp;
		PWM_SRC -> pwmrasterop;
		pwm_draw_text(x + 2, y +fb, vp);
		empty_box(bl, y + bo, bw, bw);
		if va = initval then
			PWM_SET -> pwmrasterop;
			pwm_wipe_area(bl + 2, y + bo + 2, bw - 4, bw - 4);
		endif;
		conspair(va, y) :: item.pi_value -> item.pi_value;
		y + fh -> y;
	endfor;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwmradioitem            -> pwm_make_radioitem
		pwm_gfxwipearea         -> pwm_wipe_area
		pwm_gfxtext             -> pwm_draw_text
		pwmitemhandler          -> pwm_itemhandler
		pwmgfxrasterop          -> pwmrasterop
--- Ben Rubinstein, Mar 25 1987 - added window to item record
*/
