/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 > File:        	C.pwm/lib/pwm/pwm_make_setitem.p
 > Purpose:     	a PWM item with a list of values allowing multiple choice
 > Author:     		Anthony Worrall (of Reading University), Nov 14 1988 (see revisions)
 > Documentation:   HELP PWMITEMS
 > Related Files:   LIB *PWMCYCLEITEM  LIB * PWMSLIDERITEM
 */
compile_mode :pop11 +strict;

uses pwm_itemhandler;
uses conspwmitem;
uses pwmrasterop;

section $-library$-pwmlib => pwm_make_setitem pwmset_delete pwmset_append pwmset_contents;

lvars TRACKING=false, oldmousexit=erase, oldmove=erase;
lvars oldoffset=0, cancel=false;
lvars firstselect=0, lastselect=0, selectlist=nil, selection=nil;

define lconstant display_slider(window,x,y,rows,offset,nvals);

	lvars window x y values s bs bo nvals rows fh fw offset;
	dlocal pwmgfxsurface = window,
		 pwmgfxfont = pwmstdfont,
		 pwmrasterop = PWM_NOTDST;

	pwmgfxfont.pwm_fontheight -> fh;
	pwmgfxfont.pwm_fontwidth -> fw;
	( rows - 2 ) * fh -> s;
	if nvals = 0 then s else min(s,max(1,round(s*rows/nvals))) endif; -> bs;
	if nvals = rows
	then 0
	else min(max(round((s-bs)*offset/(nvals - rows)),0),s-bs)
	endif -> bo;

	pwm_wipe_area(x-2*fw,y+fh+bo,2*fw-3,bs);
enddefine;

define lconstant displaylist(window,x,y,width,rows,values,offset,nvals);
	lvars window x y values i r nvals width rows fh fb offset;
	dlocal pwmgfxsurface = window,
		 pwmgfxfont = pwmstdfont,
		 pwmrasterop = PWM_CLR;

	pwmgfxfont.pwm_fontheight -> fh;
	pwmgfxfont.pwm_fontbaseline -> fb;

	;;;clear area;
	pwm_wipe_area(x,y,width,fh*rows);
	PWM_SRC -> pwmrasterop;

	values(nvals) -> selection;

	min(rows,nvals)-1 -> r;
	for i from 0 to r do
		pwm_draw_text(x, y + fb + i*fh, fast_back(values(i + offset)));
	endfor;

	if selection == nil then
	return;
	endif;

	for i from offset to offset+r do
		if member(values(i).fast_front,selection) then
			PWM_NOTDST -> pwmrasterop;
			pwm_wipe_area(x,y+(i-offset)*fh,width,fh);
		endif;
	endfor;

enddefine;

;;; take a value, and return pair of (value, printable version): printable
;;; version padded with spaces to VL characters
define lconstant valprintable(o,vl);
	lvars o po vl l;
	if o.islist or o.isvector then
		o(1) -> po; o(2) -> o;
	else o -> po;
	endif;
	po >< '' -> po;                 ;;;convert po into printable form
	length(po) -> l;
	if l > vl then
		substring(1,vl,po><'');   ;;;clip string only needed for pwmcycle_append
	else
		po;
		repeat (vl - l) times ><' ' endrepeat   ;;;padding
	endif -> po;
	conspair(o, po);
enddefine;

;;; mouse handlers

define lconstant pwmset_mousexit(ev,window,proc);
	lvars proc window ev;
	dlocal pwmgfxsurface = window, pwmrasterop = PWM_NOTDST;
	proc();
	oldmousexit -> pwm_eventhandler(window,"mousexit");
	if TRACKING then
		oldmove -> pwm_eventhandler(window,"move");
	endif;
	false -> TRACKING;
enddefine;

define lconstant display_move(ev,window,x,y,width,rows,values,offset,nvals,fh,s,bs);
	lvars ev,window,x,y,width,rows,values,offset,nvals,fh,s,bs,bo;
	ev(4) - y - fh -> bo;
	round(bo * ( nvals - rows ) / ( s - bs )) -> offset;
	max(0,min(offset,max(nvals-rows,0))) -> offset;
	if oldoffset /== offset then
		offset->oldoffset;
		displaylist(window,x,y,width,rows,values,offset,nvals);
	endif;
enddefine;

define lconstant pwmlist_exit(x,y,width,rows,values,offset,nvals,fh);
	lvars x,y,width,rows,values,offset,nvals,fh,i;
	for i in selectlist do
		if i >= offset and i < offset+rows then
			pwm_wipe_area(x,y+(i-offset)*fh,width,fh);
			delete(values(i).fast_front,selection) -> selection;
		endif;
	endfor;
	selection -> values(nvals);
enddefine;

define lconstant pwmlist_cancel(ev,window,x,y,width,rows,values,offset,nvals,fh);
	lvars ev,window,x,y,width,rows,values,offset,nvals,fh,i;
	if cancel then
		(ev(4) - y + 1) div fh -> i;  ;;;calculate nearest line
		max(min(i,rows-1),0)  -> i;
		if i+offset < nvals then
			if cancel /== i+offset then
				false->cancel;
			endif;
		endif;
	endif;
enddefine;

define lconstant pwmlist_select(ev,window,x,y,width,rows,values,offset,nvals,fh);
dlocal pwmgfxsurface = window;
	lvars ev,window,x,y,width,rows,values,offset,nvals,fh,i,ioff;
	(ev(4) - y + 1) div fh -> i;  ;;;calculate nearest line
	max(min(i,rows-1),0)  -> i;
	i+offset -> ioff;
	if ioff < nvals then
		switchon (ioff)
		case = firstselect then
			if lastselect /== firstselect then
				delete(values(lastselect).fast_front,selection)->selection;
				delete(lastselect,selectlist)->selectlist;
				PWM_NOTDST -> pwmrasterop;
				pwm_wipe_area(x,y+(lastselect-offset)*fh,width,fh);
				firstselect->lastselect;
			endif;
		case < firstselect then
			switchon(ioff)
			case = (lastselect-1) then
				lastselect-1->lastselect;
				lastselect::selectlist->selectlist;
				if not(member(values(lastselect).fast_front, selection)) then
					values(lastselect).fast_front::selection
						-> selection;
					PWM_NOTDST -> pwmrasterop;
					pwm_wipe_area(x,y+(lastselect-offset)*fh,width,fh);
				endif;
			case = (lastselect+1) then
				delete(values(lastselect).fast_front,selection)->selection;
				delete(lastselect,selectlist)->selectlist;
				PWM_NOTDST -> pwmrasterop;
				pwm_wipe_area(x,y+(lastselect-offset)*fh,width,fh);
				lastselect+1->lastselect;
			endswitchon;
		else
			switchon(ioff)
			case = (lastselect-1) then
				delete(values(lastselect).fast_front,selection)->selection;
				delete(lastselect,selectlist)->selectlist;
				PWM_NOTDST -> pwmrasterop;
				pwm_wipe_area(x,y+(lastselect-offset)*fh,width,fh);
				lastselect-1->lastselect;
			case = (lastselect+1) then
				lastselect+1->lastselect;
				lastselect::selectlist->selectlist;
				if not(member(values(lastselect).fast_front, selection)) then
					values(lastselect).fast_front::selection
						-> selection;
					PWM_NOTDST -> pwmrasterop;
					pwm_wipe_area(x,y+(lastselect-offset)*fh,width,fh);
				endif;
			endswitchon;
		endswitchon;
		selection -> values(nvals);
	endif;
enddefine;

;;; (a closure of) this procedure actually catches the event

define lconstant catchset(ev, window, x, y, width, rows, item);
	lvars ev window x y newval values i nvals width rows fh fw fb offset item;
	lvars s bs bo update;
	lvars current_selection;
	dlocal pwmgfxsurface = window,
		 pwmgfxfont = pwmstdfont,
		 pwmrasterop = PWM_SRC;

	pwmgfxfont.pwm_fontwidth -> fw;
	pwmgfxfont.pwm_fontheight -> fh;
	pwmgfxfont.pwm_fontbaseline-> fb;

	item.pi_value -> values;
	datalength(values)-2 -> nvals;
	values(nvals) -> selection;
	values(nvals+1) -> offset;

	switchon ev
	case .isvector then
		if fast_subscrv(1, ev) == "release" then    ;;; handle release event
			if TRACKING then
				;;;restore old mouse handlers at end of TRACKING
				oldmousexit -> pwm_eventhandler(window,"mousexit");
				oldmove -> pwm_eventhandler(window,"move");
				switchon TRACKING =
				case "SELECT" then                  ;;; handle selection
					selection -> values(nvals);
					if (item.pi_proc) then          ;;; call user proc
						(item.pi_proc)(values(nvals));
					endif;
				case "CANCEL" then
					if cancel then
						(ev(4) - y + 1) div fh -> i;  ;;;calculate nearest line
						max(min(i,rows-1),0)  -> i;
						if i+offset == cancel then
							PWM_NOTDST -> pwmrasterop;           ;;; invert line
							window -> pwmgfxsurface;
							pwm_wipe_area(x,y+i*fh,width,fh);
							i+offset -> i;
							delete(values(i).fast_front, selection)
								-> values(nvals);
							if (item.pi_proc) then                  ;;;call user proc
								(item.pi_proc)(values(nvals));
							endif;
						endif;
					endif;
				case "SLIDER" then                      ;;;handle slider
					ev(4) - y - fh -> bo;               ;;;box offset
					( rows - 2 ) * fh -> s;             ;;;size of whole slider
					;;;size of box
					min(s-1,max(1,round(s*rows/nvals))) -> bs;
					;;;calculate first visible value
					round(bo * ( nvals - rows ) / ( s - bs )) -> offset;
					;;; clip between 0 and nvals
					max(0,min(offset,max(nvals-rows,0))) -> offset;
					offset -> values(nvals+1);                      ;;;store offset
					display_slider(window,x,y,rows,offset,nvals);   ;;;update slider
					;;; update displayed text
					displaylist(window,x,y,width,rows,values,offset,nvals);
				endswitchon;
				false -> TRACKING;   ;;;tracking finished
			endif;
		else                                ;;;handle PRESS event
			if TRACKING then
				;;;rapid clicking of mouse loses release events !!!!
				;;;simulate a mouse exit to reset everything
				if (pwm_eventhandler(window,"mousexit")) then
					pwm_eventhandler(window,"mousexit")(false);
				endif;
			return;
			endif;
			if ev(4) < y-2 then
			return;
				;;; CANCELLATION/SELECTION
			elseif ev(3) > x then           ;;;selection
				unless nvals = 0 then       ;;;if no values then nothing to select
					(ev(4) - y + 1) div fh -> i;  ;;;calculate nearest line
					max(min(i,rows-1),0)  -> i;
					if i < nvals then
						i+offset -> i;
						;;;store mouse exit handler
						pwm_eventhandler(window,"mousexit") -> oldmousexit;
						;;; eventhandler can return false but will not except false
						unless oldmousexit then erase -> oldmousexit; endunless;
						;;;store mouse move handler
						pwm_eventhandler(window,"move") -> oldmove;
						;;; eventhandler can return false but will not except false
						unless oldmove then erase -> oldmove; endunless;
						if member(values(i).fast_front, selection) then
							"CANCEL"-> TRACKING;   ;;; cancelling a SELECTION
							i -> cancel;
							;;; store exit handler for CANCEL
							pwmset_mousexit(%window,identfn%)
								-> pwm_eventhandler(window,"mousexit");
							pwmlist_cancel(%window,x,y,width,rows,values,offset,nvals,fh%)
								-> pwm_eventhandler(window,"move");
						else
							"SELECT"->TRACKING;   ;;; tracking a SELECTION
							i ->> firstselect -> lastselect;
							PWM_NOTDST -> pwmrasterop;
							window -> pwmgfxsurface;
							pwm_wipe_area(x,y+(lastselect-offset)*fh,width,fh);
							values(lastselect).fast_front::selection
								->> selection -> values(nvals);
							[%i%] -> selectlist;
							;;; store exit handler for SELECT
							pwmset_mousexit(%window,pwmlist_exit(%x,y,width,rows,values,offset,nvals,fh%)%)
								-> pwm_eventhandler(window,"mousexit");
							pwmlist_select(%window,x,y,width,rows,values,offset,nvals,fh%)
								-> pwm_eventhandler(window,"move");
						endif;
						;;; start tracking
						window -> pwmgfxsurface;
						pwm_track_mouse(false,true);
					endif;
				endunless;

				;;;SCROLL TEXT DOWN BUTTON
			elseif ev(4) < y+fh then
				max((offset - 1) ,0) -> i;
				unless (i = offset) then
					display_slider(window,x,y,rows,offset,nvals);
					i -> offset;
					PWM_SRC -> pwmrasterop;
					pwm_copy_raster(window,x,y,width,(rows-1)*fh,PWM_CLR,
						window,x,y+fh);
					PWM_SRC -> pwmrasterop;
					pwm_draw_text(x,y+fb,(values(offset).fast_back));
					if member(values(offset).fast_front,selection) then
						PWM_NOTDST -> pwmrasterop;
						pwm_wipe_area(x,y,width,fh);
					endif;
					display_slider(window,x,y,rows,offset,nvals);
				endunless;

				;;;SCROLL TEXT DOWN BUTTON
			elseif ev(4) > y+(rows-1)*fh then            ;;;scroll text up
				min(offset+1, max(nvals-rows,0))  -> i;
				unless (i = offset) then
					display_slider(window,x,y,rows,offset,nvals);
					i -> offset;
					PWM_SRC -> pwmrasterop;
					pwm_copy_raster(window,x,y+fh,width,(rows-1)*fh,PWM_CLR,
						window,x,y);
					offset + rows - 1 -> i;
					PWM_SRC -> pwmrasterop;
					pwm_draw_text(x,y+(rows-1)*fh+fb,(values(i).fast_back));
					if member(values(i).fast_front, selection) then
						PWM_NOTDST -> pwmrasterop;
						pwm_wipe_area(x,y+(rows-1)*fh,width,fh);
					endif;
					display_slider(window,x,y,rows,offset,nvals);
				endunless;
			else                                ;;;slider
				if nvals > rows then
					( rows - 2 ) * fh -> s;
					min(s-1,max(1,round(s*rows/nvals))) -> bs;
					display_slider(window,x,y,rows,offset,nvals);
					"SLIDER" -> TRACKING;
					window -> pwmgfxsurface;
					pwm_track_mouse([%x-2*fw,y+fh,1,s-bs%],x-2*fw,ev(4),2*fw-3,bs,"bsheet",true);
					pwm_eventhandler(window,"mousexit") -> oldmousexit;
					unless oldmousexit then erase -> oldmousexit; endunless;
					pwm_eventhandler(window,"move") -> oldmove;
					unless oldmove then erase -> oldmove; endunless;
					pwmset_mousexit(%window,
						 displaylist(%window,x,y,width,rows,values,offset,nvals%)
						 <>display_slider(%window,x,y,rows,offset,nvals%)
						 %) -> pwm_eventhandler(window,"mousexit");
					display_move(%window,x,y,width,rows,values,offset,nvals,fh,s,bs%)
						-> pwm_eventhandler(window,"move");
					offset->oldoffset;
				endif;
			endif;
			offset -> values(nvals+1);
			;;;END OF PRESS HANDLER
		endif;
	case = "DELETE" then
			-> newval;
		false -> update;
		display_slider(window,x,y,rows,offset,nvals);
		{%
			 nvals - 1 -> nvals;
			 fast_for i from 0 to nvals do
				 values(i).fast_front -> ev;
				 if ev = newval then
					 if i >= offset and i < offset+rows then
						 true -> update;
					 endif;
					 if member(ev, selection)
					 then delete(ev, selection)->selection;
					 endif;
				 else
					 values(i);
				 endif
			 endfor;
			 selection;
			 0,
			 %} -> values;
		length(values) - 2 -> nvals;
		newanyarray([0 %nvals+1%],values) ->> values -> item.pi_value;
		min(offset, max(nvals-rows,0))  ->> offset -> values(nvals+1);
		if update then
			displaylist(window,x,y,width,rows,values,offset,nvals);
		endif;
		display_slider(window,x,y,rows,offset,nvals);

	case = "APPEND" then
			-> newval;
		display_slider(window,x,y,rows,offset,nvals);
		newanyarray([0 ^(nvals+2)], {%
				 fast_for i from 0 to nvals fi_-1 do
					 values(i);
				 endfor;
				 valprintable(newval,width div fw);
				 selection;
				 offset,
				 %}) ->> values -> item.pi_value;
		if nvals < rows then
			displaylist(window,x,y,width,rows,values,0,nvals+1);
		endif;
		display_slider(window,x,y,rows,offset,nvals+1);

	case = "UPDATE_CONTENTS" then
			-> values;
		display_slider(window,x,y,rows,offset,nvals);
		{%  if values.islist
			 then applist
			 else appdata
			 endif(values, valprintable(%width div fw%)),nil,0
			 %} -> values;
		length(values) - 2 -> nvals;
		newanyarray([0 %nvals+1%],values) ->> values -> item.pi_value;
		0 -> offset;
		displaylist(window,x,y,width,rows,values,offset,nvals);
		display_slider(window,x,y,rows,offset,nvals);

	case = true then                  ;;; please return current  value
		if selection == nil then
		return(undef);
		else
		return(selection);
		endif;
	else
			-> newval;          ;;; new value
		if newval = undef then
			nil -> values(nvals);
			displaylist(window,x,y,width,rows,values,offset,nvals);
		else
			if not(newval.islist) do
				mishap(newval, 1, 'attempt to assign bad value');
			endif;
			[% fast_for i from 0 to nvals fi_- 1 do
					 values(i).fast_front endfor%] -> ev;
			fast_for i in newval do
				if not(member(i,ev)) do
					mishap(newval, 1, 'attempt to assign bad value');
				endif;
			endfor;
			PWM_NOTDST -> pwmrasterop;
			;;; set new selection
			newval -> values(nvals);
			displaylist(window,x,y,width,rows,values,offset,nvals);
			if (item.pi_proc) then
				(item.pi_proc)(newval);
			endif;
		endif;
	endswitchon;
enddefine;

define pwmset_delete(item,val);
	lvars item val;
	(item.pi_catch)(val,"DELETE");
enddefine;

define pwmset_append(item,val);
	lvars item val;
	(item.pi_catch)(val,"APPEND");
enddefine;

;;; return contents list of item. A list of lists, where the head of
;;; the list is the displayed item and the tail is the value passed to
;;; the procedure.
define pwmset_contents(item);
	lvars i value_array item  contents_list nvals fr bk;
	item.pi_value -> value_array;
	datalength(value_array)-2 -> nvals;
	[% fast_for i from 0 to nvals fi_-1 do
			 [^(fast_back(value_array(i))) ^(fast_front(value_array(i)))];
		 endfor;
		 %];
enddefine;

define updaterof pwmset_contents(new_values, item);
	lvars new_values, item;
	(item.pi_catch)(new_values,"UPDATE_CONTENTS");
enddefine;


;;; pwm_make_setitem(<window-id>, <integer:X>, <integer:Y>,
;;;                 <vector>, <string>, <procedure>) -> <vector:Item>
;;;
;;; window, x, and y define where item goes (x and y are top left corner)
;;; vector is list of values, first one the initial value
;;;         if any value in vector is a list, it is taken as [label value]
;;; string is the label
;;; procedure is called whenever value changed
;;;
define pwm_make_setitem(window, x, y, initial_selection, values, label, cols,
												rows, proc) -> item;
	lvars	window, x, y, initial_selection, w, h, b, cols, rows, cx, cy, i,
			label, values, item, box, proc;
	dlocal	pwmrasterop, pwmgfxsurface, pwmgfxfont = pwmstdfont;

	window -> pwmgfxsurface;

	pwmstdfont.pwm_fontwidth -> w;
	pwmstdfont.pwm_fontheight -> h;
	pwmstdfont.pwm_fontbaseline -> b;

	if rows < 4 then
		max(4, min(rows,length(values))) -> rows;
	endif;

	{%  if values.islist
		 then applist
		 else appdata
		 endif(values, valprintable(%cols%)),nil,0 %} -> values;
	newanyarray([0 %length(values)-1%],values) -> values;

	max(cols,length(label)-2) -> cols;
	cols * w -> cols;

	x + cols + 4 + 2*w -> cx;
	y + 4 + rows*h+h -> cy;

	{% x, y, cx, cy %} -> box;

	;;; make up an "item" record
	conspwmitem(label, window, values, [press release], [1], box, false, proc)
		-> item;

	;;; turn proc into catcher
	catchset(% window, x +2*w+2, y + 3 + h, cols, rows, item %) -> proc;

	;;; and smash catcher into item (!)
	proc -> item.pi_catch;

	;;; assign it before drawing anything in case it's illegal
	proc -> pwm_itemhandler(window, [press release], [1], box);

	empty_box(x,y, cx-x, cy-y + 1);
	PWM_SRC -> pwmrasterop;
	pwm_draw_text(x+2,y+2+b,label);
	y + 1 + h -> y;
	pwm_draw_line(x,y,cx-1,y,2);
	pwm_draw_line(x+2*w,y,x+2*w,cy-1,2);

	pwm_draw_line(x,y+h,x+2*w,y+h,2);
	pwm_draw_line(x+3,y+h-2,x+w+1,y+2,x+2*w-1,y+h-2,x+3,y+h-2,4);

	pwm_draw_line(x,cy-h,x+2*w,cy-h,2);
	pwm_draw_line(x+3,cy-h+3,x+w+1,cy-2,x+2*w-1,cy-h+3,x+3,cy-h+3,4);

	y + 2 -> y;
	x + 2 + 2*w -> x;
	display_slider(window,x,y,rows,0,length(values)-2);
	min(rows - 1,length(values)-3) -> rows;
	for i from 0 to rows do
		pwm_draw_text(x, y + b + i*h, fast_back(values(i)));
	endfor;
	if initial_selection then
	   initial_selection -> pwm_itemvalue(item);
	endif;

enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
Converted to run under standard PWMTOOL                         DJW 6/10/89
rows >= 4 to avoid display problems                             DJW 11/12/89
Added new parameter initial_selection (pwm_make_setitem)        DJW 12/12/89
Added extra dlocals of pwmgfxsurface to prevent rasterops
appearing in base window                                        JJC 30/4/91
*/
