/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_make_toggleitem.p
 > Purpose:     a PWM input item which can be toggled on and off
 > Author:		Ben Rubinstein, Mar 15 1987 (see revisions)
 > Documentation:	HELP *PWMITEMS
 > Related Files:	LIB *PWMCYCLEITEM
 */
compile_mode :pop11 +strict;

uses conspwmitem;
uses pwm_itemhandler;
uses pwmrasterop;
uses pwm_draw_text;
uses pwm_wipe_area;

section $-library$-pwmlib => pwm_make_toggleitem;

;;; this is the procedure (a closure of) which catches the event
;;;
define lconstant catchtoggle(ev, x, y, w, item);
	lvars ev item window x y w;
	dlocal pwmgfxsurface, pwmrasterop;
	if ev.isvector and subscrv(1, ev) == "press" then
		not(item.pi_value)
	elseif ev.isvector then			;;; release - do nothing
		return
	elseif ev then 					;;; please return current  value
		return(item.pi_value);
	endif -> ev;		;;; else  get new value off stack

	unless ev.not == item.pi_value.not then
		item.pi_window -> pwmgfxsurface;
		ev -> item.pi_value;
		if ev then PWM_SET else PWM_CLR endif -> pwmrasterop;
		pwm_wipe_area(x, y, w, w);
		(item.pi_proc)(ev);
	endunless;
enddefine;

;;; pwm_make_toggleitem(<window-id>, <integer:X>, <integer:Y>,
;;;					<boolean>, <string>, <procedure>) -> <vector:Item>
;;;
;;;	window, x, and y define where item goes (x and y are top left corner)
;;;	boolean is the initial value
;;; string is the label
;;; procedure is called whenever value changed
;;;
define pwm_make_toggleitem(window, x, y, initval, label, proc) -> item;
	lvars window x y w h b l bw bo bl bt initval label proc item box;
	dlocal pwmrasterop, pwmgfxsurface = window, pwmgfxfont = pwmstdfont;

	pwmstdfont.pwm_fontwidth -> w;
	pwmstdfont.pwm_fontheight -> h;
	pwmstdfont.pwm_fontbaseline -> b;

	;;; box size is BW, offset round box BO, top left of box is BL, BT
	2 -> bo;
	h - 4 -> bw;
	w * label.datalength -> l;
	x + l + 3 + bo -> bl;
	y + 1 + bo -> bt;

	;;; the full area covered by the item
	{% x, y, bl+bw+bo, y+h+2 %} -> box;

	conspwmitem(label, window, initval,
				[press release], 1, box, false, proc) -> item;

	;;; turn proc into catcher
	catchtoggle(% bl + 2, bt + 2, bw - 4, item %) -> proc;

	;;; and smash catcher into item (!)
	proc -> item.pi_catch;

	;;;; assign catcher before we draw it, to make sure it doesn't overlap
	proc -> pwm_itemhandler(window, [press release], 1, box);

	empty_box(x, y, l + 4 + bo * 2 + bw, h + 3);

	PWM_SRC -> pwmrasterop;
	pwm_draw_text(x + 2, y + b + 2, label);

	empty_box(bl, bt, bw, bw);
	if initval then
		PWM_SET -> pwmrasterop;
		pwm_wipe_area(bl + 2, bt + 2, bw - 4, bw - 4);
	endif;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwm_gfxwipearea         -> pwm_wipe_area
		pwm_gfxtext             -> pwm_draw_text
		pwmtoggleitem           -> pwm_make_toggleitem
		pwmgfxrasterop          -> pwmrasterop
		pwmitemhandler          -> pwm_itemhandler
--- Ben Rubinstein, Mar 25 1987 - added window to item record
--- Ben Rubinstein, Mar 23 1987 - made to ignore equivalent new values
*/
