/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_mark_textarea.p
 > Purpose:		Instruct the pwm to highlight an area of text
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMWINDOWS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib  => pwm_mark_textarea;

uses pwmsequences;

define pwm_mark_textarea(win, full, l1, c1, l2, c2);
	lvars win, full, l1, c1, l2, c2;
	checkinteger(l1, 0, false);
	checkinteger(c1, 0, false);
	checkinteger(l2, 0, false);
	checkinteger(c2, 0, false);
	if (l2 < l1) or (l1 == l2 and c2 < c1) then
		mishap(l1, c1, l2, c2, 4, 'first point must be before second');
	endif;
	unless lmember(win.pwm_windowtype, [base text ved]) do
		mishap(win, 1, 'TEXT, VED or BASE TYPE WINDOW NEEDED');
	endunless;
	pwmsendmessage(l2, c2, l1, c1, checkpwmwinid(win),
							if full then 33 else ` ` endif,
							Pwms_marktext, pwmflushmessage);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - renamed from pwm_marktextarea
--- Ben Rubinstein, Feb 26 1987 - added extra checking of arguments
*/
