/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_pixel.p
 > Purpose:     Read or update the value of a pixel
 > Author:      Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:   HELP *PWM_GRAPHICS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib  => pwm_pixel;

uses pwmsequences;

define pwm_pixel(x, y);
	lvars x y;
	checkinteger(x, false, false);
	checkinteger(y, false, false);
	unless (getpwmreport(y, x, Pwms_gfxtestpixel, Pwms_numresult) == 1) do
		false
	endunless;
enddefine;

define updaterof pwm_pixel(v, x, y);
	lvars v x y;
	checkinteger(v, 0, false);
	checkinteger(x, false, false);
	checkinteger(y, false, false);
	pwmsendmessage(v, y, x, Pwms_gfxsetpixel, pwmflushmessage);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Aug  7 1989
	Renamed from -pwm_gfxpixel-
--- Poplog Documentation Officer, Sep  4 1987 (Ian Rogers)
	Second arguments of the x,y -checkinteger-'s made false in both
	procedures. pwm_gfxpixel(-1,-1) now returns -1 instead of mishap-ing.
	An 'out-of-range' update does nothing.
 */
